/*
 * Decompiled with CFR 0.152.
 */
package com.xsdexplorer.uihelpers;

import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.geometry.Pos;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.control.ScrollPane;
import javafx.scene.layout.VBox;

public class ZoomableScrollPane
extends ScrollPane {
    private double scaleValue = 1.0;
    private double zoomIntensity = 0.02;
    private Node target;
    private Node zoomNode;

    public ZoomableScrollPane(Node node) {
        this.target = node;
        this.zoomNode = new Group(new Node[]{node});
        this.setContent(this.outerNode(this.zoomNode));
        this.setFocusTraversable(false);
    }

    public void requestFocus() {
    }

    private Node outerNode(Node node) {
        Node node2 = this.centeredNode(node);
        node2.setOnScroll(scrollEvent -> {
            if (scrollEvent.isControlDown()) {
                scrollEvent.consume();
                this.onScroll(scrollEvent.getTextDeltaY(), new Point2D(scrollEvent.getX(), scrollEvent.getY()));
            }
        });
        return node2;
    }

    private Node centeredNode(Node node) {
        VBox vBox = new VBox(new Node[]{node});
        vBox.setAlignment(Pos.CENTER);
        return vBox;
    }

    private void updateScale() {
        this.target.setScaleX(this.scaleValue);
        this.target.setScaleY(this.scaleValue);
    }

    private void onScroll(double d, Point2D point2D) {
        double d2 = Math.exp(d * this.zoomIntensity);
        Bounds bounds = this.zoomNode.getLayoutBounds();
        Bounds bounds2 = this.getViewportBounds();
        double d3 = this.getHvalue() * (bounds.getWidth() - bounds2.getWidth());
        double d4 = this.getVvalue() * (bounds.getHeight() - bounds2.getHeight());
        this.scaleValue *= d2;
        this.updateScale();
        this.layout();
        Point2D point2D2 = this.target.parentToLocal(this.zoomNode.parentToLocal(point2D));
        Point2D point2D3 = this.target.getLocalToParentTransform().deltaTransform(point2D2.multiply(d2 - 1.0));
        Bounds bounds3 = this.zoomNode.getBoundsInLocal();
        this.setHvalue((d3 + point2D3.getX()) / (bounds3.getWidth() - bounds2.getWidth()));
        this.setVvalue((d4 + point2D3.getY()) / (bounds3.getHeight() - bounds2.getHeight()));
    }

    public void centerNodeInScrollPane(Node node) {
        double d = this.getContent().getBoundsInLocal().getHeight();
        Bounds bounds = node.getBoundsInParent();
        Node node2 = node;
        while (node2.getParent() != this) {
            node2 = node2.getParent();
            bounds = node2.localToParent(bounds);
        }
        double d2 = (bounds.getMaxY() + bounds.getMinY()) / 2.0;
        double d3 = this.getViewportBounds().getHeight();
        double d4 = this.getVmax() * ((d2 - 0.5 * d3) / (d - d3));
        this.setVvalue(d4);
    }
}

