/*
 * Decompiled with CFR 0.152.
 */
package com.xsdexplorer.uihelpers;

import javafx.scene.Cursor;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Region;

public class DragResizer {
    private final Region region;
    private boolean dragging;

    private DragResizer(Region region) {
        this.region = region;
    }

    public static void makeResizable(Region region) {
        DragResizer dragResizer = new DragResizer(region);
        region.addEventFilter(MouseEvent.MOUSE_PRESSED, dragResizer::mousePressed);
        region.addEventFilter(MouseEvent.MOUSE_RELEASED, dragResizer::mouseReleased);
        region.addEventFilter(MouseEvent.MOUSE_DRAGGED, dragResizer::mouseDragged);
        region.addEventFilter(MouseEvent.MOUSE_MOVED, dragResizer::mouseOver);
    }

    private void mouseReleased(MouseEvent mouseEvent) {
        this.dragging = false;
        this.region.setCursor(Cursor.DEFAULT);
    }

    private void mouseOver(MouseEvent mouseEvent) {
        if (this.isInDraggableZone(mouseEvent) || this.dragging) {
            this.region.setCursor(Cursor.W_RESIZE);
        } else {
            this.region.setCursor(Cursor.DEFAULT);
        }
    }

    private boolean isInDraggableZone(MouseEvent mouseEvent) {
        return mouseEvent.getX() <= 5.0;
    }

    private void mouseDragged(MouseEvent mouseEvent) {
        if (!this.dragging) {
            return;
        }
        double d = this.region.getWidth() - mouseEvent.getX();
        this.region.setPrefWidth(d);
    }

    private void mousePressed(MouseEvent mouseEvent) {
        if (!this.isInDraggableZone(mouseEvent)) {
            return;
        }
        this.dragging = true;
    }
}

