/*
 * Decompiled with CFR 0.152.
 */
package com.xsdexplorer.tools.gensample;

import java.util.Random;
import nl.flotsam.xeger.Xeger;
import org.apache.xerces.impl.dv.InvalidDatatypeValueException;
import org.apache.xerces.impl.dv.xs.XSSimpleTypeDecl;
import org.apache.xerces.xs.StringList;
import org.apache.xerces.xs.XSObjectList;
import org.apache.xerces.xs.XSSimpleTypeDefinition;

public class SimpleTypeGen {
    SimpleTypeGen() {
    }

    String genValue(XSSimpleTypeDecl xSSimpleTypeDecl) {
        switch (xSSimpleTypeDecl.getVariety()) {
            case 2: {
                XSSimpleTypeDecl xSSimpleTypeDecl2 = (XSSimpleTypeDecl)xSSimpleTypeDecl.getItemType();
                int n = this.getMinLength((XSSimpleTypeDefinition)xSSimpleTypeDecl2);
                StringList stringList = xSSimpleTypeDecl.getLexicalEnumeration();
                if (stringList.isEmpty()) {
                    StringBuilder stringBuilder = new StringBuilder(this.genValue(xSSimpleTypeDecl2));
                    while (--n > 0) {
                        stringBuilder.append(" ").append(this.genValue(xSSimpleTypeDecl2));
                    }
                    return stringBuilder.toString();
                }
                int n2 = stringList.getLength();
                StringBuilder stringBuilder = new StringBuilder(stringList.item(0));
                for (int i = 1; i < n; ++i) {
                    stringBuilder.append(" ").append(stringList.item(i % n2));
                }
                return stringBuilder.toString();
            }
            case 3: {
                XSObjectList xSObjectList = xSSimpleTypeDecl.getMemberTypes();
                return this.genValue((XSSimpleTypeDecl)xSObjectList.get(0));
            }
            case 1: {
                StringList stringList = xSSimpleTypeDecl.getLexicalEnumeration();
                if (!stringList.isEmpty()) {
                    return stringList.item(0);
                }
                if (xSSimpleTypeDecl.getNumeric()) {
                    return SimpleTypeGen.getNumber((XSSimpleTypeDefinition)xSSimpleTypeDecl);
                }
                switch (xSSimpleTypeDecl.getPrimitiveKind()) {
                    case 6: {
                        return "PT1004199059S";
                    }
                    case 7: {
                        try {
                            String string = "2001-10-26T21:32:52+02:00";
                            xSSimpleTypeDecl.validate(string, null, null);
                            return string;
                        }
                        catch (InvalidDatatypeValueException invalidDatatypeValueException) {
                            return "2001-10-26T21:32:52";
                        }
                    }
                    case 8: {
                        return "21:32:52";
                    }
                    case 9: {
                        return "2001-10-26";
                    }
                    case 10: {
                        return "2001-10";
                    }
                    case 11: {
                        return "2001";
                    }
                    case 12: {
                        return "--05-01";
                    }
                    case 13: {
                        return "---17";
                    }
                    case 14: {
                        return "--05";
                    }
                    case 2: {
                        try {
                            xSSimpleTypeDecl.validate("false", null, null);
                            return "false";
                        }
                        catch (InvalidDatatypeValueException invalidDatatypeValueException) {
                            return "0";
                        }
                    }
                    case 16: {
                        return "++++";
                    }
                    case 15: {
                        return "3f3c";
                    }
                }
                StringList stringList2 = xSSimpleTypeDecl.getLexicalPattern();
                if (stringList2 != null && !stringList2.isEmpty()) {
                    String string = stringList2.item(0);
                    Xeger xeger = new Xeger(string, new Random(0L));
                    return xeger.generate();
                }
                return "String";
            }
        }
        return "String";
    }

    private int getMinLength(XSSimpleTypeDefinition xSSimpleTypeDefinition) {
        String string = xSSimpleTypeDefinition.getLexicalFacetValue((short)1);
        if (string != null) {
            return Integer.parseInt(string);
        }
        String string2 = xSSimpleTypeDefinition.getLexicalFacetValue((short)2);
        if (string2 != null) {
            return Integer.parseInt(string2);
        }
        return 1;
    }

    private static String getNumber(XSSimpleTypeDefinition xSSimpleTypeDefinition) {
        XSSimpleTypeDecl xSSimpleTypeDecl = (XSSimpleTypeDecl)xSSimpleTypeDefinition;
        int n = -1;
        String string = xSSimpleTypeDefinition.getLexicalFacetValue((short)1024);
        if (string != null) {
            n = Integer.parseInt(string);
        }
        Double d = SimpleTypeGen.getDouble(xSSimpleTypeDecl.getMinInclusiveValue());
        Object object = xSSimpleTypeDecl.getMinExclusiveValue();
        if (object != null) {
            d = Double.parseDouble(object.toString()) + 1.0;
        }
        Double d2 = SimpleTypeGen.getDouble(xSSimpleTypeDecl.getMaxInclusiveValue());
        Object object2 = xSSimpleTypeDecl.getMaxExclusiveValue();
        if (object2 != null) {
            d2 = Double.parseDouble(object2.toString()) - 1.0;
        }
        if (d == null && d2 == null) {
            return SimpleTypeGen.getWithFractionDigits(0.0, n);
        }
        if (d == null) {
            return SimpleTypeGen.getWithFractionDigits(0.0 <= d2 ? 0.0 : d2, n);
        }
        if (d2 == null) {
            return SimpleTypeGen.getWithFractionDigits(0.0 >= d ? 0.0 : d, n);
        }
        return SimpleTypeGen.getWithFractionDigits(0.0 >= d && 0.0 <= d2 ? 0.0 : (d + d2) / 2.0, n);
    }

    private static Double getDouble(Object object) {
        return object == null ? null : Double.valueOf(object.toString());
    }

    private static String getWithFractionDigits(double d, int n) {
        return n != -1 ? String.format("%." + n + "f", d) : String.valueOf(d);
    }
}

