/*
 * Decompiled with CFR 0.152.
 */
package com.xsdexplorer.loader;

import com.xsdexplorer.LogView;
import com.xsdexplorer.loader.SchemaLoader;
import java.io.File;
import javafx.concurrent.Task;

public class SchemaLoaderTask
extends Task<SchemaLoader> {
    private SchemaLoader schemaLoader = new SchemaLoader();
    private final File[] files;
    private boolean hasErrors;

    public SchemaLoaderTask(File ... fileArray) {
        this.files = fileArray;
    }

    protected SchemaLoader call() throws Exception {
        this.schemaLoader.messageProperty().addListener((observableValue, string, string2) -> {
            if (string2.startsWith(LogView.Kind.ERROR.toString())) {
                this.hasErrors = true;
            }
            this.updateMessage((String)string2);
        });
        for (File file : this.files) {
            this.schemaLoader.loadSchema(file);
            if (this.hasErrors) {
                this.hasErrors = false;
                continue;
            }
            this.updateMessage(LogView.Kind.SUCCESS.formatMessage(file + " is valid"));
        }
        return this.schemaLoader;
    }
}

