/*
 * Decompiled with CFR 0.152.
 */
package com.xsdexplorer.loader;

import com.google.common.base.Preconditions;
import com.xsdexplorer.loader.SchemaLoader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.Map;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.xerces.xni.XMLResourceIdentifier;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.parser.XMLEntityResolver;
import org.apache.xerces.xni.parser.XMLInputSource;

public class EntityResolverImpl
implements XMLEntityResolver {
    private Map<Path, byte[]> fileToContent = Collections.emptyMap();

    public void setFileContentMap(Map<Path, byte[]> map) {
        this.fileToContent = map;
    }

    public XMLInputSource resolveEntity(XMLResourceIdentifier xMLResourceIdentifier) throws XNIException, IOException {
        String string = xMLResourceIdentifier.getPublicId();
        String string2 = xMLResourceIdentifier.getLiteralSystemId();
        String string3 = xMLResourceIdentifier.getNamespace();
        String string4 = xMLResourceIdentifier.getExpandedSystemId();
        System.out.println("publicId: " + string + ", systemId: " + string2 + ", namespace: " + string3 + ", exp system id: " + string4);
        if (string2 != null && string2.endsWith(".dtd")) {
            return EntityResolverImpl.getEmptySource(xMLResourceIdentifier);
        }
        if ("http://www.w3.org/XML/1998/namespace".equals(string3)) {
            return EntityResolverImpl.getSource(xMLResourceIdentifier, "/catalog/xml.xsd");
        }
        if (!this.fileToContent.isEmpty()) {
            try {
                return this.getSourceFromByteArray(xMLResourceIdentifier, this.getFileContent(Paths.get(new URI(string4))));
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new RuntimeException(uRISyntaxException);
            }
        }
        if (string4 != null && string4.startsWith("http")) {
            return EntityResolverImpl.getHtppInputSource(xMLResourceIdentifier);
        }
        return null;
    }

    public XMLInputSource getSourceFromPath(Path path) {
        byte[] byArray = this.getFileContent(path);
        XMLInputSource xMLInputSource = new XMLInputSource(null, path.toString(), null);
        xMLInputSource.setByteStream((InputStream)new ByteArrayInputStream(byArray));
        return xMLInputSource;
    }

    private byte[] getFileContent(Path path) {
        byte[] byArray = (byte[])Preconditions.checkNotNull((Object)this.fileToContent.get(path), (String)"cannot find xsd for %s", (Object)path);
        return byArray;
    }

    private XMLInputSource getSourceFromByteArray(XMLResourceIdentifier xMLResourceIdentifier, byte[] byArray) {
        XMLInputSource xMLInputSource = new XMLInputSource(xMLResourceIdentifier);
        xMLInputSource.setByteStream((InputStream)new ByteArrayInputStream(byArray));
        return xMLInputSource;
    }

    private static XMLInputSource getEmptySource(XMLResourceIdentifier xMLResourceIdentifier) throws IOException {
        XMLInputSource xMLInputSource = new XMLInputSource(xMLResourceIdentifier);
        xMLInputSource.setByteStream((InputStream)new ByteArrayInputStream(new byte[0]));
        return xMLInputSource;
    }

    private static XMLInputSource getSource(XMLResourceIdentifier xMLResourceIdentifier, String string) throws IOException {
        InputStream inputStream = SchemaLoader.class.getResourceAsStream(string);
        if (inputStream == null) {
            System.err.println("Warning: resource not found: " + string);
            return null;
        }
        XMLInputSource xMLInputSource = new XMLInputSource(xMLResourceIdentifier);
        xMLInputSource.setByteStream(inputStream);
        return xMLInputSource;
    }

    public static XMLInputSource getHtppInputSource(XMLResourceIdentifier xMLResourceIdentifier) throws IOException {
        XMLInputSource xMLInputSource = new XMLInputSource(xMLResourceIdentifier);
        CloseableHttpClient closeableHttpClient = HttpClients.createDefault();
        HttpGet httpGet = new HttpGet(xMLResourceIdentifier.getExpandedSystemId());
        ClassicHttpResponse classicHttpResponse = closeableHttpClient.executeOpen(null, (ClassicHttpRequest)httpGet, null);
        HttpEntity httpEntity = classicHttpResponse.getEntity();
        xMLInputSource.setEncoding(httpEntity.getContentEncoding());
        xMLInputSource.setByteStream(httpEntity.getContent());
        return xMLInputSource;
    }
}

