/*
 * Decompiled with CFR 0.152.
 */
package com.xsdexplorer;

import com.google.common.base.Preconditions;
import com.xsdexplorer.AnnotationExtractor;
import com.xsdexplorer.ComplexTypeExtractor;
import com.xsdexplorer.ConnEdges;
import com.xsdexplorer.ExternalEditor;
import com.xsdexplorer.NodeLabel;
import com.xsdexplorer.RecursionNode;
import com.xsdexplorer.SubstEdges;
import com.xsdexplorer.TreeNodeControl;
import com.xsdexplorer.XsdTreeView;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import javafx.scene.text.Text;
import org.apache.xerces.impl.xs.SchemaGrammar;
import org.apache.xerces.impl.xs.XSComplexTypeDecl;
import org.apache.xerces.xs.XSAnnotation;
import org.apache.xerces.xs.XSAttributeUse;
import org.apache.xerces.xs.XSElementDeclaration;
import org.apache.xerces.xs.XSModelGroup;
import org.apache.xerces.xs.XSObject;
import org.apache.xerces.xs.XSObjectList;
import org.apache.xerces.xs.XSParticle;
import org.apache.xerces.xs.XSTerm;
import org.apache.xerces.xs.XSTypeDefinition;
import org.apache.xerces.xs.XSWildcard;

public class XsdTreeNode
extends TreeNodeControl {
    static final double ANNOTATION_WRAP = 140.0;
    private XSObject term;
    private NodeControl control = new NodeControl();
    private XsdTreeView parentLayout;
    private boolean isOpen = false;
    private int minOccurs = 1;
    private int maxOccurs = 1;
    private XsdTreeNode parentTreeNode;
    private XSParticle particle;
    private NodeLabel label;
    private ConnEdges connEdges;
    private TypeRectangle typeRectangle;
    private SubstEdges substEdges;
    private List<XsdTreeNode> substGroup;

    public XsdTreeNode(XSParticle xSParticle, XsdTreeNode xsdTreeNode) {
        this.minOccurs = xSParticle.getMinOccurs();
        this.maxOccurs = xSParticle.getMaxOccurs();
        this.parentLayout = xsdTreeNode.parentLayout;
        this.parentTreeNode = xsdTreeNode;
        this.particle = xSParticle;
        this.init((XSObject)xSParticle.getTerm());
    }

    private XsdTreeNode(XSObject xSObject, XsdTreeNode xsdTreeNode) {
        this.minOccurs = xsdTreeNode.minOccurs;
        this.maxOccurs = xsdTreeNode.maxOccurs;
        this.parentLayout = xsdTreeNode.parentLayout;
        this.parentTreeNode = xsdTreeNode;
        this.init(xSObject);
    }

    public XsdTreeNode(XSObject xSObject, XsdTreeView xsdTreeView) {
        this.parentLayout = xsdTreeView;
        this.init(xSObject);
    }

    private void init(XSObject xSObject) {
        this.term = xSObject;
        this.label = NodeLabel.createNodeLabel(this);
        if (this.label.getOnClickControl() != null) {
            this.label.getOnClickControl().setOnMouseClicked(this::onPlusClicked);
        }
        this.label.setOnMouseClicked(this::onMouseClicked);
        this.label.focusedProperty().addListener((observableValue, bl, bl2) -> {
            if (bl2.booleanValue()) {
                this.onFocused();
            }
        });
        this.label.setOnContextMenuRequested(contextMenuEvent -> this.getParentLayout().getContextMenu(this).show((Node)this.label, contextMenuEvent.getScreenX(), contextMenuEvent.getScreenY()));
        this.control.getChildren().add((Object)this.label);
        this.addOccursLabel();
        this.addAnnotation();
        this.parentLayout.addNode(this);
        this.substGroup = this.getSubstitutionGroup().stream().map(xSElementDeclaration -> new XsdTreeNode((XSObject)xSElementDeclaration, this)).sorted((xsdTreeNode, xsdTreeNode2) -> xsdTreeNode.getTerm().getName().compareTo(xsdTreeNode2.getTerm().getName())).toList();
        this.substEdges = SubstEdges.createIfNeeded(this);
        if (this.isLoop()) {
            this.isOpen = true;
            this.childNodes = List.of(new RecursionNode(this.particle.toString(), this.getParentLayout()));
            this.connEdges = new ConnEdges(this);
        }
    }

    @Override
    public List<TreeNodeControl> getChildrenForLayout() {
        return this.childNodes.stream().flatMap(treeNodeControl -> {
            Stream<TreeNodeControl> stream;
            if (treeNodeControl instanceof XsdTreeNode) {
                XsdTreeNode xsdTreeNode = (XsdTreeNode)treeNodeControl;
                stream = Stream.concat(Stream.of(treeNodeControl), xsdTreeNode.getSubstGroup().stream());
            } else {
                stream = Stream.of(treeNodeControl);
            }
            return stream;
        }).toList();
    }

    void onOpenExternalEditor() {
        XsdTreeNode xsdTreeNode = this;
        while (!xsdTreeNode.isGlobal()) {
            xsdTreeNode = xsdTreeNode.parentTreeNode;
        }
        ExternalEditor externalEditor = new ExternalEditor();
        externalEditor.openInExternalEditor(this.getParentLayout().getModel(), xsdTreeNode.term);
    }

    public boolean isGroup() {
        return this.term.getType() == 7;
    }

    public boolean isAny() {
        return this.term.getType() == 9;
    }

    public boolean isElement() {
        return this.term.getType() == 2;
    }

    public boolean isGlobalRef() {
        return this.parentTreeNode != null && this.isElement() && this.element().getScope() == 1;
    }

    public boolean isGlobal() {
        return this.parentTreeNode == null || this.isGlobalRef();
    }

    public boolean isType() {
        return this.term.getType() == 3;
    }

    public XSModelGroup group() {
        return (XSModelGroup)this.term;
    }

    public XSElementDeclaration element() {
        return (XSElementDeclaration)this.term;
    }

    public XSWildcard any() {
        return (XSWildcard)this.term;
    }

    public XSTypeDefinition type() {
        return (XSTypeDefinition)this.term;
    }

    public String anyOrGroupCompositor() {
        return this.isAny() ? "any" : this.groupCompositor();
    }

    public String groupCompositor() {
        String[] stringArray = new String[]{"sequence", "choice", "all"};
        return stringArray[this.group().getCompositor() - 1];
    }

    public List<XSParticle> groupParticles() {
        return this.group().getParticles();
    }

    static List<XSParticle> groupParticles(XSTerm xSTerm) {
        return ((XSModelGroup)xSTerm).getParticles();
    }

    private List<XSElementDeclaration> getSubstitutionGroup() {
        if (this.isElement()) {
            try {
                XSObjectList xSObjectList = this.getParentLayout().getModel().getSubstitutionGroup((XSElementDeclaration)this.term);
                return xSObjectList == null ? Collections.emptyList() : xSObjectList;
            }
            catch (Exception exception) {
                return Collections.emptyList();
            }
        }
        return Collections.emptyList();
    }

    public List<XsdTreeNode> getSubstGroup() {
        return this.substGroup;
    }

    private void onMouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getButton() == MouseButton.PRIMARY) {
            this.label.requestFocus();
            mouseEvent.consume();
        }
    }

    private void onFocused() {
        this.getParentLayout().onNodeFocused(this);
    }

    private void onPlusClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getButton() == MouseButton.PRIMARY) {
            mouseEvent.consume();
            this.toggleExpand();
        }
    }

    public void toggleExpand() {
        this.label.toggleOpenControl();
        if (this.isOpen) {
            this.isOpen = false;
            XsdTreeNode.hideSubtree(this);
            return;
        }
        this.isOpen = true;
        if (this.childNodes.size() > 0) {
            XsdTreeNode.showSubtree(this);
        } else {
            this.populateChildren();
            this.connEdges = new ConnEdges(this);
            this.autoexpand();
        }
        this.getParentLayout().onNodeExpanded(this);
    }

    private void autoexpand() {
        if (this.hasSingleChild() || this.childNodes.stream().filter(treeNodeControl -> treeNodeControl instanceof XsdTreeNode).skip(1L).findAny().isEmpty()) {
            for (TreeNodeControl treeNodeControl2 : this.childNodes) {
                treeNodeControl2.expand(false);
            }
        }
    }

    @Override
    void expand(boolean bl) {
        if ((this.isGroup() || bl) && this.label.getOnClickControl() != null) {
            this.toggleExpand();
        }
    }

    @Override
    public Pane getTypeRectange() {
        return this.typeRectangle;
    }

    boolean allChildrenOptional() {
        for (TreeNodeControl treeNodeControl : this.childNodes) {
            if (treeNodeControl.isOptional()) continue;
            return false;
        }
        return true;
    }

    private static void hideSubtree(TreeNodeControl treeNodeControl) {
        for (TreeNodeControl treeNodeControl2 : treeNodeControl.getChildrenForLayout()) {
            treeNodeControl2.setVisible(false);
            XsdTreeNode.hideSubtree(treeNodeControl2);
        }
    }

    private static void showSubtree(TreeNodeControl treeNodeControl) {
        for (TreeNodeControl treeNodeControl2 : treeNodeControl.getChildrenForLayout()) {
            treeNodeControl2.setVisible(true);
            if (!treeNodeControl2.isOpen()) continue;
            XsdTreeNode.showSubtree(treeNodeControl2);
        }
    }

    private boolean isLoop() {
        if (!this.isGroup()) {
            return false;
        }
        XsdTreeNode xsdTreeNode = this.parentTreeNode;
        while (xsdTreeNode != null) {
            if (xsdTreeNode.particle == this.particle) {
                return true;
            }
            xsdTreeNode = xsdTreeNode.parentTreeNode;
        }
        return false;
    }

    private void populateChildren() {
        if (this.isGroup()) {
            this.childNodes = this.groupParticles().stream().map(xSParticle -> new XsdTreeNode((XSParticle)xSParticle, this)).toList();
        } else if (!this.isAny()) {
            XSComplexTypeDecl xSComplexTypeDecl = this.getComplexType();
            if (xSComplexTypeDecl == null) {
                return;
            }
            int n = this.getParentLayout().getChildren().size();
            String string = this.getTypeName();
            boolean bl = string != null && string.endsWith("(ext)");
            ComplexTypeExtractor complexTypeExtractor = new ComplexTypeExtractor(bl);
            this.childNodes = complexTypeExtractor.extractComplexTypeChildren(xSComplexTypeDecl, this, this.options());
            if (string != null) {
                int n2;
                if (bl) {
                    n2 = complexTypeExtractor.getBaseTypeSize();
                } else {
                    Preconditions.checkState((complexTypeExtractor.getBaseTypeSize() == 0 ? 1 : 0) != 0);
                    n2 = this.childNodes.size();
                }
                if (n2 > 0) {
                    this.typeRectangle = new TypeRectangle(string, n2 - 1);
                    this.getParentLayout().getChildren().add(n, (Object)this.typeRectangle);
                    this.typeRectangle.visibleProperty().bind((ObservableValue)this.firstChild().visibleProperty());
                }
            }
        }
    }

    private List<XSAttributeUse> getAttributes() {
        XSComplexTypeDecl xSComplexTypeDecl = this.options().showAttributes.get() ? this.getComplexType() : null;
        return xSComplexTypeDecl != null ? XsdTreeNode.castAttrList(xSComplexTypeDecl.getAttributeUses()) : Collections.emptyList();
    }

    private static List<XSAttributeUse> castAttrList(XSObjectList xSObjectList) {
        return xSObjectList;
    }

    private String getTypeName() {
        if (!this.options().showTypes.get()) {
            return null;
        }
        XSComplexTypeDecl xSComplexTypeDecl = this.getComplexType();
        if (xSComplexTypeDecl == null) {
            return null;
        }
        if (xSComplexTypeDecl.getContentType() >= 2 || !xSComplexTypeDecl.getAttributeUses().isEmpty()) {
            if (!xSComplexTypeDecl.getAnonymous() && !this.isType()) {
                return xSComplexTypeDecl.getName();
            }
            if (xSComplexTypeDecl.getBaseType() instanceof XSComplexTypeDecl && xSComplexTypeDecl.getDerivationMethod() == 1) {
                return xSComplexTypeDecl.getBaseType().getName() + " (ext)";
            }
        }
        return null;
    }

    boolean hasXsdChildren() {
        if (this.isLoop()) {
            return false;
        }
        if (!this.getAttributes().isEmpty()) {
            return true;
        }
        if (this.isGroup()) {
            return !this.groupParticles().isEmpty();
        }
        if (this.isAny()) {
            return false;
        }
        if (this.isElement()) {
            XSTypeDefinition xSTypeDefinition = this.element().getTypeDefinition();
            if (!SchemaGrammar.isAnyType((XSTypeDefinition)xSTypeDefinition)) {
                XSParticle xSParticle = this.getComplexContent(xSTypeDefinition);
                return xSParticle != null;
            }
            return false;
        }
        XSObject xSObject = this.term;
        if (xSObject instanceof XSComplexTypeDecl) {
            XSComplexTypeDecl xSComplexTypeDecl = (XSComplexTypeDecl)xSObject;
            return xSComplexTypeDecl.getParticle() != null;
        }
        return false;
    }

    public boolean isSimpleContent() {
        if (this.isElement()) {
            XSComplexTypeDecl xSComplexTypeDecl = this.getComplexType();
            if (xSComplexTypeDecl == null) {
                return true;
            }
            return xSComplexTypeDecl.getContentType() <= 1;
        }
        return false;
    }

    public boolean hasComplexContent(XSTypeDefinition xSTypeDefinition) {
        XSComplexTypeDecl xSComplexTypeDecl;
        return xSTypeDefinition instanceof XSComplexTypeDecl && (xSComplexTypeDecl = (XSComplexTypeDecl)xSTypeDefinition).getContentType() >= 2;
    }

    private XSComplexTypeDecl getComplexType() {
        XSObject xSObject;
        if (this.isElement()) {
            XSTypeDefinition xSTypeDefinition = this.element().getTypeDefinition();
            if (xSTypeDefinition instanceof XSComplexTypeDecl) {
                XSComplexTypeDecl xSComplexTypeDecl = (XSComplexTypeDecl)xSTypeDefinition;
                return xSComplexTypeDecl;
            }
        } else if (this.isType() && (xSObject = this.term) instanceof XSComplexTypeDecl) {
            XSComplexTypeDecl xSComplexTypeDecl = (XSComplexTypeDecl)xSObject;
            return xSComplexTypeDecl;
        }
        return null;
    }

    private XSParticle getComplexContent(XSTypeDefinition xSTypeDefinition) {
        if (xSTypeDefinition instanceof XSComplexTypeDecl) {
            XSComplexTypeDecl xSComplexTypeDecl = (XSComplexTypeDecl)xSTypeDefinition;
            return xSComplexTypeDecl.getParticle();
        }
        return null;
    }

    public boolean isRepeating() {
        return this.maxOccurs > 1 || this.maxOccurs == -1;
    }

    private void addOccursLabel() {
        if (this.maxOccurs == 0 || this.maxOccurs == 1) {
            return;
        }
        Text text = new Text(String.format("%d..%s", this.minOccurs, this.maxOccurs > 0 ? String.valueOf(this.maxOccurs) : "\u221e"));
        this.control.addOccursLabel(text);
    }

    private void addAnnotation() {
        String string;
        XSAnnotation xSAnnotation;
        if (!this.options().showAnnotations.get()) {
            return;
        }
        XSAnnotation xSAnnotation2 = this.isElement() ? this.element().getAnnotation() : (this.isGroup() ? this.group().getAnnotation() : (xSAnnotation = this.isAny() ? this.any().getAnnotation() : this.getTypeAnnotation()));
        if (xSAnnotation != null && (string = AnnotationExtractor.extract(xSAnnotation.getAnnotationString())) != null) {
            this.control.addAnnot(string);
        }
    }

    private XSAnnotation getTypeAnnotation() {
        XSComplexTypeDecl xSComplexTypeDecl;
        XSObject xSObject = this.term;
        if (xSObject instanceof XSComplexTypeDecl && !(xSObject = (xSComplexTypeDecl = (XSComplexTypeDecl)xSObject).getAnnotations()).isEmpty()) {
            return (XSAnnotation)xSObject.get(0);
        }
        return null;
    }

    public void reset() {
        this.control.getChildren().clear();
        this.childNodes.clear();
        this.isOpen = false;
        this.connEdges = null;
        this.typeRectangle = null;
        this.control.getChildren().add((Object)this.label);
        this.addOccursLabel();
        this.addAnnotation();
        this.label.resetOpenControl(this.hasXsdChildren());
        if (this.label.getOnClickControl() != null) {
            this.label.getOnClickControl().setOnMouseClicked(this::onPlusClicked);
        }
    }

    public XsdTreeView getParentLayout() {
        return this.parentLayout;
    }

    public NodeLabel getLabel() {
        return this.label;
    }

    public double getLabelHeight() {
        return this.label.getHeight();
    }

    private XsdTreeView.Options options() {
        return this.getParentLayout().getOptions();
    }

    public String toString() {
        return String.format("'%s', open: %b, children num: %d", this.label.getText(), this.isOpen, this.childNodes.size());
    }

    public XSObject getTerm() {
        return this.term;
    }

    public XsdTreeNode getParentTreeNode() {
        return this.parentTreeNode;
    }

    public int getMinOccurs() {
        return this.minOccurs;
    }

    public int getMaxOccurs() {
        return this.maxOccurs;
    }

    @Override
    public boolean isOpen() {
        return this.isOpen;
    }

    @Override
    Region control() {
        return this.control;
    }

    @Override
    boolean isOptional() {
        return this.minOccurs == 0;
    }

    @Override
    public void layoutSubstEdges(double d) {
        if (this.substEdges != null) {
            this.substEdges.layoutSubstElements(this, d);
        }
    }

    @Override
    public void layoutEdges(double d) {
        this.connEdges.layoutEdges(this, d);
    }

    public String getXpath() {
        if (!this.isElement()) {
            return "";
        }
        LinkedList<String> linkedList = new LinkedList<String>();
        XsdTreeNode xsdTreeNode = this;
        linkedList.add(this.term.getName());
        while (xsdTreeNode.getParentTreeNode() != null) {
            xsdTreeNode = xsdTreeNode.parentTreeNode;
            if (!xsdTreeNode.isElement()) continue;
            linkedList.add(0, xsdTreeNode.term.getName());
        }
        return linkedList.stream().collect(Collectors.joining("/", "/", ""));
    }

    private class NodeControl
    extends VBox {
        private Text annot;

        public NodeControl() {
            this.setFillWidth(false);
        }

        void addOccursLabel(Text text) {
            this.getChildren().add((Object)text);
            VBox.setMargin((Node)text, (Insets)new Insets(0.0, 0.0, 0.0, 6.0));
        }

        public void addAnnot(String string) {
            this.annot = new Text(string);
            this.annot.getStyleClass().add((Object)"annotation");
            this.getChildren().add((Object)this.annot);
            VBox.setMargin((Node)this.annot, (Insets)new Insets(6.0, 0.0, 0.0, 0.0));
        }

        protected double computeMinWidth(double d) {
            return this.computePrefWidth(d);
        }

        protected double computePrefWidth(double d) {
            this.fixAnnotationWrap();
            double d2 = super.computePrefWidth(d);
            return d2;
        }

        private void fixAnnotationWrap() {
            if (this.annot != null) {
                double d = Double.max(140.0, XsdTreeNode.this.label.prefWidth(-1.0));
                this.annot.setWrappingWidth(d);
            }
        }
    }

    static class TypeRectangle
    extends Pane {
        final int childrenInType;

        TypeRectangle(String string, int n) {
            this.childrenInType = n;
            Text text = new Text(string);
            text.relocate(10.0, 8.0);
            this.getChildren().add((Object)text);
            this.getStyleClass().add((Object)"TypeRectangle");
        }
    }
}

