/*
 * Decompiled with CFR 0.152.
 */
package com.xsdexplorer;

import com.xsdexplorer.uihelpers.Utils;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.MenuItem;

public class LogView {
    private ListView<Record> listView;

    public void addMessage(Kind kind, String string) {
        ObservableList observableList = this.listView.getItems();
        int n = observableList.size();
        observableList.add((Object)new Record(kind, string));
        this.listView.scrollTo(n);
    }

    public void clear() {
        this.listView.getItems().clear();
    }

    public Parent createLogView() {
        this.listView = new ListView();
        this.listView.setPrefHeight(80.0);
        this.listView.setCellFactory(listView -> {
            ListCell<Record> listCell = new ListCell<Record>(){
                final ContextMenu contextMenu;
                {
                    this.contextMenu = LogView.this.createContextMenu();
                }

                public void updateItem(Record record, boolean bl) {
                    super.updateItem((Object)record, bl);
                    if (bl) {
                        this.setText(null);
                        this.setTooltip(null);
                        this.setContextMenu(null);
                        this.setGraphic(null);
                    } else {
                        this.setText(record.message);
                        Label label = new Label();
                        label.getStyleClass().add((Object)record.kind.style);
                        this.setGraphic((Node)label);
                        this.setOnContextMenuRequested(contextMenuEvent -> this.contextMenu.show((Node)this, contextMenuEvent.getScreenX(), contextMenuEvent.getScreenY()));
                    }
                }
            };
            return listCell;
        });
        return this.listView;
    }

    private ContextMenu createContextMenu() {
        MenuItem menuItem = new MenuItem("Copy");
        MenuItem menuItem2 = new MenuItem("Copy All");
        MenuItem menuItem3 = new MenuItem("Clear");
        ContextMenu contextMenu = new ContextMenu(new MenuItem[]{menuItem, menuItem2, menuItem3});
        menuItem.setOnAction(actionEvent -> {
            Node node = contextMenu.getOwnerNode();
            if (node instanceof ListCell) {
                ListCell listCell = (ListCell)node;
                Utils.clipboardCopy(listCell.getText());
            }
        });
        menuItem2.setOnAction(actionEvent -> {
            ObservableList observableList = this.listView.getItems();
            Utils.clipboardCopyList(observableList);
        });
        menuItem3.setOnAction(actionEvent -> this.listView.getItems().clear());
        return contextMenu;
    }

    private static class Record {
        Kind kind;
        String message;

        public Record(Kind kind, String string) {
            this.kind = kind;
            this.message = string;
        }

        public String toString() {
            return this.message;
        }
    }

    public static enum Kind {
        INFO("infoIcon"),
        SUCCESS("successIcon"),
        WARNING("warningIcon"),
        ERROR("errorIcon");

        private String style;

        private Kind(String string2) {
            this.style = string2;
        }

        public String toString() {
            return "[" + this.name() + "]";
        }

        public String formatMessage(String string) {
            return "[" + this.name() + "] " + string;
        }
    }
}

