/*
 * Decompiled with CFR 0.152.
 */
package com.xsdexplorer;

import com.xsdexplorer.XsdTreeNode;
import com.xsdexplorer.uihelpers.DragResizer;
import com.xsdexplorer.uihelpers.FilterableTreeItem;
import com.xsdexplorer.uihelpers.TreeItemPredicate;
import com.xsdexplorer.uihelpers.Utils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.Tooltip;
import javafx.scene.control.TreeCell;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.KeyCode;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import javafx.util.Callback;
import javafx.util.Duration;
import org.apache.commons.lang3.StringUtils;
import org.apache.xerces.impl.dv.DatatypeException;
import org.apache.xerces.impl.dv.xs.XSSimpleTypeDecl;
import org.apache.xerces.impl.xs.SchemaGrammar;
import org.apache.xerces.impl.xs.SchemaSymbols;
import org.apache.xerces.impl.xs.XSComplexTypeDecl;
import org.apache.xerces.impl.xs.XSWildcardDecl;
import org.apache.xerces.xs.StringList;
import org.apache.xerces.xs.XSAttributeDeclaration;
import org.apache.xerces.xs.XSAttributeUse;
import org.apache.xerces.xs.XSElementDeclaration;
import org.apache.xerces.xs.XSFacet;
import org.apache.xerces.xs.XSModel;
import org.apache.xerces.xs.XSModelGroup;
import org.apache.xerces.xs.XSModelGroupDefinition;
import org.apache.xerces.xs.XSObject;
import org.apache.xerces.xs.XSTypeDefinition;
import org.apache.xerces.xs.datatypes.ObjectList;

public class GlobalsToolbar {
    private XSModel model;
    private TreeView<TreeViewRecord> treeView;
    private Consumer<XSObject> selectedCallback;
    private TableView<Prop> treeTableView = this.createPropertiesPanel();
    private TextField searchField = new TextField();
    private Map<XSModelGroup, String> globalModelGroups;

    public GlobalsToolbar(XSModel xSModel, Consumer<XSObject> consumer) {
        this.model = xSModel;
        this.selectedCallback = consumer;
        this.globalModelGroups = this.fillGlobalModelGroups();
    }

    public Parent createToolBar() {
        VBox vBox = new VBox();
        Node node = this.createGlobalsTree();
        vBox.getChildren().addAll((Object[])new Node[]{this.createTextFilter(), node, this.treeTableView});
        VBox.setVgrow(this.treeTableView, (Priority)Priority.NEVER);
        VBox.setVgrow((Node)node, (Priority)Priority.ALWAYS);
        vBox.setFillWidth(true);
        DragResizer.makeResizable((Region)vBox);
        return vBox;
    }

    private Node createTextFilter() {
        Label label = new Label("Search: ");
        HBox hBox = new HBox(5.0, new Node[]{label, this.searchField});
        hBox.setAlignment(Pos.CENTER_LEFT);
        HBox.setMargin((Node)this.searchField, (Insets)new Insets(2.0, 0.0, 2.0, 0.0));
        this.searchField.setOnKeyPressed(keyEvent -> {
            if (keyEvent.getCode() == KeyCode.ESCAPE) {
                this.searchField.clear();
            }
        });
        return hBox;
    }

    private void initCellFactloty() {
        final ContextMenu contextMenu = GlobalsToolbar.createContextMenu();
        this.treeView.setCellFactory(treeView -> {
            TreeCell<TreeViewRecord> treeCell = new TreeCell<TreeViewRecord>(){

                public void updateItem(TreeViewRecord treeViewRecord, boolean bl) {
                    super.updateItem((Object)treeViewRecord, bl);
                    if (bl) {
                        this.setText(null);
                        this.setOnContextMenuRequested(null);
                        this.setTooltip(null);
                    } else {
                        this.setText(treeViewRecord.name);
                        this.setOnContextMenuRequested(contextMenuEvent -> contextMenu.show((Node)this, contextMenuEvent.getScreenX(), contextMenuEvent.getScreenY()));
                        if (treeViewRecord.xsObject != null) {
                            OnDemandTooltip onDemandTooltip = new OnDemandTooltip(treeViewRecord.xsObject);
                            onDemandTooltip.setShowDelay(Duration.millis((double)500.0));
                            onDemandTooltip.setShowDuration(Duration.millis((double)10000.0));
                            this.setTooltip(onDemandTooltip);
                        }
                    }
                }
            };
            treeCell.setOnMouseClicked(arg_0 -> this.lambda$initCellFactloty$1((TreeCell)treeCell, arg_0));
            return treeCell;
        });
    }

    private static ContextMenu createContextMenu() {
        MenuItem menuItem = new MenuItem("Copy");
        ContextMenu contextMenu = new ContextMenu(new MenuItem[]{menuItem});
        menuItem.setOnAction(actionEvent -> {
            Node node = contextMenu.getOwnerNode();
            if (node instanceof TreeCell) {
                TreeCell treeCell = (TreeCell)node;
                Utils.clipboardCopy(treeCell.getText());
            }
        });
        return contextMenu;
    }

    private Node createGlobalsTree() {
        TreeView treeView = this.treeView = new TreeView();
        this.initCellFactloty();
        TreeItem treeItem = new TreeItem((Object)new TreeViewRecord("Globals"));
        treeView.setRoot(treeItem);
        treeView.setShowRoot(false);
        treeView.setPrefHeight(200.0);
        StringList stringList = this.model.getNamespaces();
        for (int i = 0; i < stringList.size(); ++i) {
            FilterableTreeItem<TreeViewRecord> filterableTreeItem;
            String string = (String)stringList.get(i);
            List<XSObject> list = this.getComponentsByNamespace((short)2, string).stream().sorted((xSObject, xSObject2) -> xSObject.getName().compareToIgnoreCase(xSObject2.getName())).toList();
            Map<Boolean, List<XSObject>> map = this.getComponentsByNamespace((short)3, string).stream().sorted((xSObject, xSObject2) -> xSObject.getName().compareToIgnoreCase(xSObject2.getName())).collect(Collectors.partitioningBy(xSObject -> xSObject instanceof XSComplexTypeDecl));
            List<XSObject> list2 = map.get(true);
            List<XSObject> list3 = map.get(false);
            if (list.isEmpty() && list2.isEmpty() && list3.isEmpty()) continue;
            TreeItem treeItem2 = new TreeItem((Object)new TreeViewRecord(string == null || string.isEmpty() ? "<no namespace>" : string));
            treeItem.getChildren().add((Object)treeItem2);
            treeItem2.setExpanded(true);
            if (!list.isEmpty()) {
                filterableTreeItem = new FilterableTreeItem<TreeViewRecord>(new TreeViewRecord("element"));
                treeItem2.getChildren().add(filterableTreeItem);
                for (XSObject xSObject3 : list) {
                    filterableTreeItem.getInternalChildren().add((Object)new TreeItem((Object)new TreeViewRecord(xSObject3.getName(), xSObject3)));
                }
                this.bindSearchProperty(filterableTreeItem);
                filterableTreeItem.getBackingList().addListener((ListChangeListener)new SmallListExpander(filterableTreeItem));
            }
            if (!list2.isEmpty()) {
                filterableTreeItem = new FilterableTreeItem<TreeViewRecord>(new TreeViewRecord("complexType"));
                treeItem2.getChildren().add(filterableTreeItem);
                for (XSObject xSObject3 : list2) {
                    filterableTreeItem.getInternalChildren().add((Object)new TreeItem((Object)new TreeViewRecord(xSObject3.getName(), xSObject3)));
                }
                this.bindSearchProperty(filterableTreeItem);
                filterableTreeItem.getBackingList().addListener((ListChangeListener)new SmallListExpander(filterableTreeItem));
            }
            if (list3.isEmpty()) continue;
            filterableTreeItem = new FilterableTreeItem<TreeViewRecord>(new TreeViewRecord("simpleType"));
            treeItem2.getChildren().add(filterableTreeItem);
            for (XSObject xSObject3 : list3) {
                filterableTreeItem.getInternalChildren().add((Object)new TreeItem((Object)new TreeViewRecord(xSObject3.getName(), xSObject3)));
            }
            this.bindSearchProperty(filterableTreeItem);
            filterableTreeItem.getBackingList().addListener((ListChangeListener)new SmallListExpander(filterableTreeItem));
        }
        return treeView;
    }

    private TreeItemPredicate<TreeViewRecord> searchTreeItemPredicate() {
        if (this.searchField.getText() == null || this.searchField.getText().isEmpty()) {
            return null;
        }
        return this::shouldFilter;
    }

    private boolean shouldFilter(TreeItem<TreeViewRecord> treeItem, TreeViewRecord treeViewRecord) {
        String string = this.searchField.getText();
        return StringUtils.containsIgnoreCase((CharSequence)treeViewRecord.name, (CharSequence)string);
    }

    private void bindSearchProperty(FilterableTreeItem<TreeViewRecord> filterableTreeItem) {
        filterableTreeItem.predicateProperty().bind((ObservableValue)Bindings.createObjectBinding(this::searchTreeItemPredicate, (Observable[])new Observable[]{this.searchField.textProperty()}));
    }

    private Collection<XSObject> getComponentsByNamespace(short s, String string) {
        return this.model.getComponentsByNamespace(s, string).values();
    }

    private Collection<XSModelGroupDefinition> getModelGroups() {
        return this.model.getComponents((short)6).values();
    }

    private Map<XSModelGroup, String> fillGlobalModelGroups() {
        HashMap<XSModelGroup, String> hashMap = new HashMap<XSModelGroup, String>();
        for (XSModelGroupDefinition xSModelGroupDefinition : this.getModelGroups()) {
            hashMap.put(xSModelGroupDefinition.getModelGroup(), xSModelGroupDefinition.getName());
        }
        return hashMap;
    }

    private TableView<Prop> createPropertiesPanel() {
        TableView tableView = new TableView();
        tableView.setPrefHeight(220.0);
        tableView.setMaxHeight(Double.NEGATIVE_INFINITY);
        TableColumn tableColumn2 = new TableColumn("Key");
        TableColumn tableColumn3 = new TableColumn("Value");
        tableColumn2.setCellValueFactory((Callback)new PropertyValueFactory("key"));
        tableColumn3.setCellValueFactory((Callback)new PropertyValueFactory("value"));
        tableColumn3.setCellFactory(tableColumn -> {
            TableCell<Prop, Object> tableCell = new TableCell<Prop, Object>(){

                protected void updateItem(Object object, boolean bl) {
                    super.updateItem(object, bl);
                    if (bl) {
                        this.setText(null);
                        this.setGraphic(null);
                    } else if (object instanceof XSTypeDefinition) {
                        XSTypeDefinition xSTypeDefinition = (XSTypeDefinition)object;
                        this.setText(null);
                        Hyperlink hyperlink = new Hyperlink(xSTypeDefinition.getName());
                        this.setGraphic((Node)hyperlink);
                        hyperlink.setOnAction(actionEvent -> GlobalsToolbar.this.selectedCallback.accept((XSObject)xSTypeDefinition));
                    } else {
                        this.setText(object == null ? null : object.toString());
                        this.setGraphic(null);
                    }
                }
            };
            return tableCell;
        });
        tableView.getColumns().add((Object)tableColumn2);
        tableView.getColumns().add((Object)tableColumn3);
        tableView.setOnKeyPressed(keyEvent -> {
            Prop prop;
            if (keyEvent.getCode() == KeyCode.C && keyEvent.isControlDown() && (prop = (Prop)tableView.getSelectionModel().getSelectedItem()) != null) {
                String string = prop.toString();
                Utils.clipboardCopy(string);
            }
        });
        return tableView;
    }

    private static Prop prop(String string, Object object) {
        return new Prop(string, object);
    }

    private List<Prop> getElementProps(XsdTreeNode xsdTreeNode) {
        XSTypeDefinition xSTypeDefinition;
        XSElementDeclaration xSElementDeclaration = (XSElementDeclaration)xsdTreeNode.getTerm();
        XSObject xSObject = xsdTreeNode.getParentTreeNode() != null ? xsdTreeNode.getParentTreeNode().getTerm() : null;
        ArrayList<Prop> arrayList = new ArrayList<Prop>();
        arrayList.add(GlobalsToolbar.prop("name", xSElementDeclaration.getName()));
        if (xSObject != null) {
            if (xSObject.getType() == 7) {
                arrayList.add(GlobalsToolbar.prop("isRef", Boolean.valueOf(xSElementDeclaration.getScope() == 1).toString()));
            }
            arrayList.add(GlobalsToolbar.prop("minOccurs", String.valueOf(xsdTreeNode.getMinOccurs())));
            arrayList.add(GlobalsToolbar.prop("maxOccurs", xsdTreeNode.getMaxOccurs() == -1 ? "unbounded" : String.valueOf(xsdTreeNode.getMaxOccurs())));
        }
        if ((xSTypeDefinition = xSElementDeclaration.getTypeDefinition()) instanceof XSComplexTypeDecl) {
            XSComplexTypeDecl xSComplexTypeDecl = (XSComplexTypeDecl)xSTypeDefinition;
            this.addComplexTypeNameAndDerivedBy(xSComplexTypeDecl, arrayList);
            arrayList.add(GlobalsToolbar.prop("content", "complex"));
            arrayList.add(GlobalsToolbar.prop("mixed", Boolean.valueOf(xSComplexTypeDecl.getContentType() == 3).toString()));
            String string = "";
            if (xSElementDeclaration.getSubstitutionGroupAffiliation() != null) {
                string = xSElementDeclaration.getSubstitutionGroupAffiliation().getName();
            }
            arrayList.add(GlobalsToolbar.prop("substGroup", string));
            arrayList.add(GlobalsToolbar.prop("abstract", Boolean.valueOf(xSElementDeclaration.getAbstract()).toString()));
        } else {
            arrayList.add(GlobalsToolbar.prop("type", xSTypeDefinition));
            arrayList.add(GlobalsToolbar.prop("content", "simple"));
            arrayList.add(GlobalsToolbar.prop("default", xSElementDeclaration.getConstraintType() == 1 ? xSElementDeclaration.getValueConstraintValue().getNormalizedValue() : ""));
            arrayList.add(GlobalsToolbar.prop("fixed", xSElementDeclaration.getConstraintType() == 2 ? xSElementDeclaration.getValueConstraintValue().getNormalizedValue() : ""));
        }
        arrayList.add(GlobalsToolbar.prop("nillable", Boolean.valueOf(xSElementDeclaration.getNillable()).toString()));
        return arrayList;
    }

    private void addComplexTypeNameAndDerivedBy(XSComplexTypeDecl xSComplexTypeDecl, List<Prop> list) {
        XSComplexTypeDecl xSComplexTypeDecl2 = null;
        String string = null;
        if (!xSComplexTypeDecl.getAnonymous()) {
            xSComplexTypeDecl2 = xSComplexTypeDecl;
        } else if (!SchemaGrammar.isAnyType((XSTypeDefinition)xSComplexTypeDecl.getBaseType()) || xSComplexTypeDecl.getDerivationMethod() == 1) {
            xSComplexTypeDecl2 = xSComplexTypeDecl.getBaseType();
            string = xSComplexTypeDecl.getDerivationMethod() == 1 ? "extension" : "restriction";
        }
        list.add(GlobalsToolbar.prop("type", xSComplexTypeDecl2));
        list.add(GlobalsToolbar.prop("derived by", string));
    }

    private List<Prop> getModelGroupProps(XsdTreeNode xsdTreeNode) {
        XSModelGroup xSModelGroup = xsdTreeNode.group();
        ArrayList<Prop> arrayList = new ArrayList<Prop>();
        arrayList.add(GlobalsToolbar.prop("name", this.globalModelGroups.get(xSModelGroup)));
        arrayList.add(GlobalsToolbar.prop("minOccurs", String.valueOf(xsdTreeNode.getMinOccurs())));
        arrayList.add(GlobalsToolbar.prop("maxOccurs", xsdTreeNode.getMaxOccurs() == -1 ? "unbounded" : String.valueOf(xsdTreeNode.getMaxOccurs())));
        return arrayList;
    }

    private List<Prop> getTypeProps(XsdTreeNode xsdTreeNode) {
        XSTypeDefinition xSTypeDefinition = (XSTypeDefinition)xsdTreeNode.getTerm();
        ArrayList<Prop> arrayList = new ArrayList<Prop>();
        arrayList.add(GlobalsToolbar.prop("name", xSTypeDefinition.getName()));
        if (xSTypeDefinition instanceof XSComplexTypeDecl) {
            XSComplexTypeDecl xSComplexTypeDecl = (XSComplexTypeDecl)xSTypeDefinition;
            XSTypeDefinition xSTypeDefinition2 = !SchemaGrammar.isAnyType((XSTypeDefinition)xSTypeDefinition.getBaseType()) || xSComplexTypeDecl.getDerivationMethod() == 1 || SchemaSymbols.URI_SCHEMAFORSCHEMA.equals(xSComplexTypeDecl.getTargetNamespace()) ? xSTypeDefinition.getBaseType() : null;
            arrayList.add(GlobalsToolbar.prop("base", xSTypeDefinition2));
            arrayList.add(GlobalsToolbar.prop("derived by", xSTypeDefinition2 == null ? "" : (xSComplexTypeDecl.getDerivationMethod() == 1 ? "extension" : "restriction")));
            arrayList.add(GlobalsToolbar.prop("mixed", Boolean.valueOf(xSComplexTypeDecl.getContentType() == 3).toString()));
            arrayList.add(GlobalsToolbar.prop("abstract", Boolean.valueOf(xSComplexTypeDecl.getAbstract()).toString()));
        } else {
            Object object;
            String[] stringArray;
            ObjectList objectList;
            XSSimpleTypeDecl xSSimpleTypeDecl = (XSSimpleTypeDecl)xSTypeDefinition;
            XSTypeDefinition xSTypeDefinition3 = xSSimpleTypeDecl.getBaseType();
            if (xSTypeDefinition3 != null && !"".equals(xSTypeDefinition3.getName())) {
                arrayList.add(GlobalsToolbar.prop("base", xSTypeDefinition3));
            }
            if (!(objectList = xSSimpleTypeDecl.getActualEnumeration()).isEmpty()) {
                arrayList.add(GlobalsToolbar.prop("enum", objectList.toString()));
            }
            if (xSSimpleTypeDecl.getVariety() != 3) {
                try {
                    stringArray = new String[]{"preserve", "replace", "collapse"};
                    object = stringArray[xSSimpleTypeDecl.getWhitespace()];
                    arrayList.add(GlobalsToolbar.prop("whitespace", object));
                }
                catch (DatatypeException datatypeException) {}
            } else {
                stringArray = xSSimpleTypeDecl.getMemberTypes();
                arrayList.add(GlobalsToolbar.prop("union", stringArray.toString()));
            }
            stringArray = xSSimpleTypeDecl.getLexicalPattern();
            if (!stringArray.isEmpty()) {
                arrayList.add(GlobalsToolbar.prop("pattern", stringArray.toString()));
            }
            arrayList.add(GlobalsToolbar.prop("length", (object = (XSFacet)xSSimpleTypeDecl.getFacet(1)) != null ? object.getLexicalFacetValue() : null));
            object = (XSFacet)xSSimpleTypeDecl.getFacet(2);
            arrayList.add(GlobalsToolbar.prop("minLength", object != null ? object.getLexicalFacetValue() : null));
            object = (XSFacet)xSSimpleTypeDecl.getFacet(4);
            arrayList.add(GlobalsToolbar.prop("maxLength", object != null ? object.getLexicalFacetValue() : null));
        }
        return arrayList;
    }

    private List<Prop> getWildcardProps(XsdTreeNode xsdTreeNode) {
        XSWildcardDecl xSWildcardDecl = (XSWildcardDecl)xsdTreeNode.getTerm();
        ArrayList<Prop> arrayList = new ArrayList<Prop>();
        arrayList.add(GlobalsToolbar.prop("name", xSWildcardDecl.getName()));
        arrayList.add(GlobalsToolbar.prop("description", xSWildcardDecl.toString()));
        return arrayList;
    }

    private List<Prop> getAttributeProps(XSAttributeUse xSAttributeUse) {
        XSAttributeDeclaration xSAttributeDeclaration = xSAttributeUse.getAttrDeclaration();
        ArrayList<Prop> arrayList = new ArrayList<Prop>();
        arrayList.add(GlobalsToolbar.prop("name", xSAttributeDeclaration.getName()));
        arrayList.add(GlobalsToolbar.prop("type", xSAttributeDeclaration.getTypeDefinition()));
        arrayList.add(GlobalsToolbar.prop("required", String.valueOf(xSAttributeUse.getRequired())));
        arrayList.add(GlobalsToolbar.prop("default", xSAttributeUse.getConstraintType() == 1 ? xSAttributeUse.getValueConstraintValue().getNormalizedValue() : ""));
        arrayList.add(GlobalsToolbar.prop("fixed", xSAttributeUse.getConstraintType() == 2 ? xSAttributeUse.getValueConstraintValue().getNormalizedValue() : ""));
        return arrayList;
    }

    public void populatePropsFor(Object object) {
        ObservableList observableList = this.treeTableView.getItems();
        observableList.clear();
        List<Object> list = Collections.emptyList();
        if (object instanceof XsdTreeNode) {
            XsdTreeNode xsdTreeNode = (XsdTreeNode)object;
            XSObject xSObject = xsdTreeNode.getTerm();
            switch (xSObject.getType()) {
                case 2: {
                    list = this.getElementProps(xsdTreeNode);
                    break;
                }
                case 7: {
                    list = this.getModelGroupProps(xsdTreeNode);
                    break;
                }
                case 3: {
                    list = this.getTypeProps(xsdTreeNode);
                    break;
                }
                case 9: {
                    list = this.getWildcardProps(xsdTreeNode);
                }
            }
        } else if (object instanceof XSAttributeUse) {
            XSAttributeUse xSAttributeUse = (XSAttributeUse)object;
            list = this.getAttributeProps(xSAttributeUse);
        }
        observableList.addAll(list);
    }

    private /* synthetic */ void lambda$initCellFactloty$1(TreeCell treeCell, MouseEvent mouseEvent) {
        if (mouseEvent.getButton().equals((Object)MouseButton.PRIMARY) && mouseEvent.getClickCount() == 2 && !treeCell.isEmpty()) {
            TreeItem treeItem = treeCell.getTreeItem();
            XSObject xSObject = ((TreeViewRecord)treeItem.getValue()).xsObject;
            if (xSObject != null) {
                this.selectedCallback.accept(xSObject);
            }
        }
    }

    private static class TreeViewRecord {
        String name;
        XSObject xsObject;

        public TreeViewRecord(String string) {
            this.name = string;
        }

        public TreeViewRecord(String string, XSObject xSObject) {
            this.name = string;
            this.xsObject = xSObject;
        }

        public String toString() {
            return this.name;
        }
    }

    private static class SmallListExpander
    implements ListChangeListener<TreeItem<TreeViewRecord>> {
        private FilterableTreeItem<TreeViewRecord> elItem;

        SmallListExpander(FilterableTreeItem<TreeViewRecord> filterableTreeItem) {
            this.elItem = filterableTreeItem;
        }

        public void onChanged(ListChangeListener.Change<? extends TreeItem<TreeViewRecord>> change) {
            while (change.next()) {
                if (!change.wasRemoved() || change.getList().size() >= 6) continue;
                this.elItem.setExpanded(true);
                return;
            }
        }
    }

    public static class Prop {
        String key;
        Object value;

        Prop(String string, Object object) {
            this.key = string;
            this.value = object;
        }

        public String getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public String toString() {
            Object object = this.value;
            if (object instanceof XSTypeDefinition) {
                XSTypeDefinition xSTypeDefinition = (XSTypeDefinition)object;
                return xSTypeDefinition.getName();
            }
            return this.value == null ? "" : this.value.toString();
        }
    }

    private static class OnDemandTooltip
    extends Tooltip {
        private XSObject o;

        public OnDemandTooltip(XSObject xSObject) {
            this.o = xSObject;
        }

        protected void show() {
            if (this.getGraphic() == null) {
                Object object;
                XSElementDeclaration xSElementDeclaration;
                XSObject xSObject = this.o;
                if (xSObject instanceof XSElementDeclaration) {
                    xSElementDeclaration = (XSElementDeclaration)xSObject;
                    object = xSElementDeclaration.getName() + ": " + xSElementDeclaration.getTypeDefinition().toString();
                } else {
                    object = this.o.toString();
                }
                object = ((String)object).replace(", ", "\n");
                object = this.fixParticle((String)object);
                xSElementDeclaration = new Label((String)object);
                xSElementDeclaration.setWrapText(true);
                xSElementDeclaration.setMinHeight(Double.NEGATIVE_INFINITY);
                xSElementDeclaration.setMinWidth(Double.NEGATIVE_INFINITY);
                this.setGraphic((Node)xSElementDeclaration);
            }
            super.show();
        }

        private String fixParticle(String string) {
            String string2;
            Object object;
            int n = string.indexOf("particle='");
            if (n == -1) {
                return string;
            }
            int n2 = string.indexOf(10, n);
            if (n2 == -1) {
                n2 = string.length();
            }
            if (((String)(object = (string2 = string.substring(n, n2)).replaceAll("\"[^\"]+\":", ""))).length() > 100) {
                object = ((String)object).substring(0, 97) + "...";
            }
            return string.replace(string2, (CharSequence)object);
        }
    }
}

