/*
 * Decompiled with CFR 0.152.
 */
package com.xsdexplorer;

import com.xsdexplorer.XsdExplorer;
import com.xsdexplorer.loader.XmlFactory;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.io.IOUtils;
import org.apache.xerces.impl.xs.SchemaGrammar;
import org.apache.xerces.impl.xs.XSComplexTypeDecl;
import org.apache.xerces.impl.xs.XSModelImpl;
import org.apache.xerces.xs.XSModel;
import org.apache.xerces.xs.XSObject;
import org.apache.xerces.xs.datatypes.ObjectList;
import org.codehaus.stax2.XMLStreamReader2;

public class ExternalEditor {
    public static String getCurrentEditor() {
        return XsdExplorer.getApp().getPrefs().get("externalEditor", ExternalEditor.getDefaultEditor());
    }

    public static void setCurrentEditor(String string) {
        XsdExplorer.getApp().getPrefs().put("externalEditor", string);
    }

    private static String getDefaultEditor() {
        Object object;
        String string = System.getenv("ProgramFiles");
        if (string != null && ((File)(object = new File(string, "Notepad++/notepad++.exe"))).exists()) {
            return ((File)object).getAbsolutePath();
        }
        string = System.getenv("ProgramFiles(x86)");
        if (string != null && ((File)(object = new File(string, "Notepad++/notepad++.exe"))).exists()) {
            return ((File)object).getAbsolutePath();
        }
        object = ExternalEditor.getNotepadPlusPlusRegistryLocation();
        if (object != null) {
            return object;
        }
        return "notepad.exe";
    }

    private static String getNotepadPlusPlusRegistryLocation() {
        try {
            Process process = new ProcessBuilder("reg", "query", "HKLM\\SOFTWARE\\Notepad++", "/ve").redirectErrorStream(true).start();
            String string = IOUtils.toString((InputStream)process.getInputStream(), (Charset)StandardCharsets.UTF_8);
            int n = string.indexOf("REG_SZ");
            if (n == -1) {
                return null;
            }
            String string2 = string.substring(n + 6).trim();
            File file = new File(string2, "notepad++.exe");
            return file.exists() ? file.getAbsolutePath() : null;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    void openInExternalEditor(XSModel xSModel, XSObject xSObject) {
        XSModelImpl xSModelImpl = (XSModelImpl)xSModel;
        String string = xSObject.getNamespace() == null ? "" : xSObject.getNamespace();
        String string2 = xSObject.getName();
        int n = xSModelImpl.getLength();
        for (int i = 0; i < n; ++i) {
            String string3;
            SchemaGrammar schemaGrammar = (SchemaGrammar)xSModelImpl.get(i);
            String string4 = string3 = schemaGrammar.getTargetNamespace() == null ? "" : schemaGrammar.getTargetNamespace();
            if (!string3.equals(string)) continue;
            ObjectList objectList = schemaGrammar.getComponentsExt(xSObject.getType());
            for (int j = 0; j < objectList.getLength(); j += 2) {
                File file;
                int n2;
                String string5 = (String)objectList.get(j);
                if (!string5.endsWith(string2) || string5.charAt(n2 = string5.length() - string2.length() - 1) != ',') continue;
                String string6 = string5.substring(0, n2);
                if (string6.startsWith("file://")) {
                    string6 = string6.substring(7);
                }
                if (!(file = new File(string6)).exists()) {
                    return;
                }
                try {
                    int n3 = this.detectLine(file, xSObject);
                    this.openEditor(file, n3);
                }
                catch (Exception exception) {
                    System.out.println("error opening external file: " + exception.getMessage());
                }
                return;
            }
        }
    }

    public void openEditor(File file, int n) throws IOException {
        String string = ExternalEditor.getCurrentEditor();
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string);
        arrayList.add(file.getAbsolutePath());
        if (string.contains("notepad++")) {
            arrayList.add("-n" + n);
        }
        ProcessBuilder processBuilder = new ProcessBuilder(arrayList);
        processBuilder.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int detectLine(File file, XSObject xSObject) throws XMLStreamException {
        String string = xSObject.getType() == 2 ? "element" : (xSObject instanceof XSComplexTypeDecl ? "complexType" : "simpleType");
        String string2 = xSObject.getName();
        XMLStreamReader2 xMLStreamReader2 = null;
        try {
            xMLStreamReader2 = XmlFactory.factory.createXMLStreamReader(file);
            xMLStreamReader2.nextTag();
            if (!xMLStreamReader2.getLocalName().equals("schema")) {
                int n = 1;
                return n;
            }
            while (xMLStreamReader2.hasNext()) {
                String string3;
                int n = xMLStreamReader2.nextTag();
                if (n != 1) {
                    int n2 = 1;
                    return n2;
                }
                String string4 = xMLStreamReader2.getLocalName();
                if (string4.equals(string) && string2.equals(string3 = xMLStreamReader2.getAttributeValue(null, "name"))) {
                    int n3 = xMLStreamReader2.getLocation().getLineNumber();
                    return n3;
                }
                xMLStreamReader2.skipElement();
            }
        }
        finally {
            if (xMLStreamReader2 != null) {
                xMLStreamReader2.closeCompletely();
            }
        }
        return 1;
    }
}

