/*
 * Decompiled with CFR 0.152.
 */
package com.xsdexplorer;

import com.xsdexplorer.TreeNodeControl;
import com.xsdexplorer.XsdTreeNode;
import javafx.beans.property.BooleanProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.geometry.Bounds;
import javafx.scene.Node;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Line;

public class ConnEdges {
    public static final double EDGE_LEN = 15.0;
    private Line hLine;
    private Line vLine;
    private Line[] childHLines;

    public ConnEdges(XsdTreeNode xsdTreeNode) {
        ObservableList observableList = xsdTreeNode.getParentLayout().getChildren();
        BooleanProperty booleanProperty = xsdTreeNode.firstChild().visibleProperty();
        this.hLine = ConnEdges.confLine(xsdTreeNode.isOptional(), booleanProperty, (ObservableList<Node>)observableList);
        int n = xsdTreeNode.childNodes().size();
        if (n > 1) {
            this.vLine = ConnEdges.confLine(xsdTreeNode.allChildrenOptional(), booleanProperty, (ObservableList<Node>)observableList);
            this.childHLines = new Line[n];
            int n2 = 0;
            for (TreeNodeControl treeNodeControl : xsdTreeNode.childNodes()) {
                int n3 = n2++;
                Line line = ConnEdges.confLine(treeNodeControl.isOptional(), booleanProperty, (ObservableList<Node>)observableList);
                this.childHLines[n3] = line;
                Line line2 = line;
                line2.setEndX(15.0);
            }
        }
    }

    private static Line confLine(boolean bl, BooleanProperty booleanProperty, ObservableList<Node> observableList) {
        Line line = new Line();
        line.setStroke((Paint)Color.BLACK);
        if (bl) {
            line.getStrokeDashArray().addAll((Object[])new Double[]{2.0, 4.0});
        }
        line.visibleProperty().bind((ObservableValue)booleanProperty);
        observableList.add((Object)line);
        return line;
    }

    public void layoutEdges(XsdTreeNode xsdTreeNode, double d) {
        double d2;
        Bounds bounds;
        if (this.vLine != null) {
            bounds = xsdTreeNode.firstChild().getBoundsInParent();
            Bounds bounds2 = xsdTreeNode.lastChild().getBoundsInParent();
            double d3 = bounds2.getMinY() - bounds.getMinY();
            this.vLine.setEndY(d3);
            double d4 = bounds.getMinX() - 15.0;
            this.vLine.relocate(d4, bounds.getMinY() + d / 2.0);
            for (int i = 0; i < this.childHLines.length; ++i) {
                Bounds bounds3 = ((TreeNodeControl)xsdTreeNode.childNodes.get(i)).getBoundsInParent();
                this.childHLines[i].relocate(d4, bounds3.getMinY() + d / 2.0);
            }
            d2 = d4;
        } else {
            bounds = xsdTreeNode.firstChild().getBoundsInParent();
            d2 = bounds.getMinX();
        }
        bounds = xsdTreeNode.getBoundsInParent();
        double d5 = bounds.getMinX() + xsdTreeNode.getLabel().getWidth();
        this.hLine.setEndX(d2 - d5);
        this.hLine.relocate(d5, bounds.getMinY() + d / 2.0);
    }
}

