/*
 * Decompiled with CFR 0.152.
 */
package nl.flotsam.xeger;

import dk.brics.automaton.Automaton;
import dk.brics.automaton.RegExp;
import dk.brics.automaton.State;
import dk.brics.automaton.Transition;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.stream.Collectors;

public class Xeger {
    private final Automaton automaton;
    private Random random;

    public Xeger(String regex, Random random) {
        assert (regex != null);
        assert (random != null);
        this.automaton = new RegExp(regex).toAutomaton();
        this.random = random;
    }

    public Xeger(String regex) {
        this(regex, new Random());
    }

    public String generate() {
        StringBuilder builder = new StringBuilder();
        this.generate(builder, this.automaton.getInitialState());
        return builder.toString();
    }

    public String generate(int minLength, int maxLength) throws FailedRandomWalkException {
        List transitions;
        int walkLength;
        StringBuilder builder = new StringBuilder();
        State state = this.automaton.getInitialState();
        int targetLength = Xeger.getRandomInt(minLength, maxLength, this.random);
        for (walkLength = 0; walkLength < targetLength; ++walkLength) {
            transitions = state.getSortedTransitions(false);
            if (transitions.size() == 0) {
                if (walkLength >= minLength) {
                    assert (state.isAccept());
                    return builder.toString();
                }
                throw new FailedRandomWalkException(String.format("Reached accept state before minimum length (current = %d < min = %d)", walkLength, minLength));
            }
            List nonFinalTransitions = transitions.stream().filter(t -> !t.getDest().getTransitions().isEmpty()).collect(Collectors.toList());
            if (!nonFinalTransitions.isEmpty()) {
                transitions = nonFinalTransitions;
            }
            int option = Xeger.getRandomInt(0, transitions.size() - 1, this.random);
            Transition transition = (Transition)transitions.get(option);
            this.appendChoice(builder, transition);
            state = transition.getDest();
        }
        while (!state.isAccept() && walkLength < maxLength) {
            transitions = state.getSortedTransitions(false);
            if (transitions.size() == 0) {
                assert (state.isAccept());
                return builder.toString();
            }
            int option = Xeger.getRandomInt(0, transitions.size() - 1, this.random);
            Transition transition = (Transition)transitions.get(option);
            this.appendChoice(builder, transition);
            state = transition.getDest();
            ++walkLength;
        }
        if (state.isAccept()) {
            return builder.toString();
        }
        throw new FailedRandomWalkException(String.format("Exceeded maximum walk length (%d) before reaching an accept state: target length was %d (min length = %d)", maxLength, targetLength, minLength));
    }

    private Optional<Transition> appendRandomChoice(StringBuilder builder, State state, int minLength, int walkLength) throws FailedRandomWalkException {
        List transitions = state.getSortedTransitions(false);
        if (transitions.size() == 0) {
            if (walkLength >= minLength) {
                return Optional.empty();
            }
            throw new FailedRandomWalkException(String.format("Reached accept state before minimum length (current = %d < min = %d)", walkLength, minLength));
        }
        int option = Xeger.getRandomInt(0, transitions.size() - 1, this.random);
        Transition transition = (Transition)transitions.get(option);
        this.appendChoice(builder, transition);
        return Optional.of(transition);
    }

    private void generate(StringBuilder builder, State state) {
        List transitions = state.getSortedTransitions(false);
        if (transitions.size() == 0) {
            assert (state.isAccept());
            return;
        }
        int nroptions = state.isAccept() ? transitions.size() : transitions.size() - 1;
        int option = Xeger.getRandomInt(0, nroptions, this.random);
        if (state.isAccept() && option == 0) {
            return;
        }
        Transition transition = (Transition)transitions.get(option - (state.isAccept() ? 1 : 0));
        this.appendChoice(builder, transition);
        this.generate(builder, transition.getDest());
    }

    private void appendChoice(StringBuilder builder, Transition transition) {
        char c = (char)Xeger.getRandomInt(transition.getMin(), transition.getMax(), this.random);
        builder.append(c);
    }

    public Random getRandom() {
        return this.random;
    }

    public void setRandom(Random random) {
        this.random = random;
    }

    static int getRandomInt(int min, int max, Random random) {
        int maxForRandom = max - min + 1;
        return random.nextInt(maxForRandom) + min;
    }

    public static class FailedRandomWalkException
    extends Exception {
        public FailedRandomWalkException(String message) {
            super(message);
        }
    }
}

