/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.xs.traversers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.xerces.impl.xs.SchemaSymbols;
import org.apache.xerces.impl.xs.traversers.OverrideTransformException;
import org.apache.xerces.impl.xs.traversers.OverrideTransformer;
import org.apache.xerces.impl.xs.traversers.XSDHandler;
import org.apache.xerces.util.DOMUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class OverrideTransformationManager {
    public static final int STATE_INCLUDE = 1;
    public static final int STATE_CONTINUE = 2;
    public static final int STATE_DUPLICATE = 3;
    public static final int STATE_COLLISION = 4;
    private static String[] fGlobalComponentNames = new String[]{SchemaSymbols.ELT_ATTRIBUTEGROUP, SchemaSymbols.ELT_ATTRIBUTE, SchemaSymbols.ELT_COMPLEXTYPE, SchemaSymbols.ELT_SIMPLETYPE, SchemaSymbols.ELT_ELEMENT, SchemaSymbols.ELT_NOTATION, SchemaSymbols.ELT_GROUP};
    private static String[] fCompositeComponentNames = new String[]{SchemaSymbols.ELT_INCLUDE, SchemaSymbols.ELT_OVERRIDE, SchemaSymbols.ELT_REDEFINE};
    private OverrideTransformer fOverrideTransformationHandler;
    private final HashMap fSystemId2ContextMap = new HashMap();
    private int fCurrentState = 1;
    private final XSDHandler fSchemaHandler;

    public OverrideTransformationManager(XSDHandler handler, OverrideTransformer overrideHandler) {
        this.fSchemaHandler = handler;
        this.fOverrideTransformationHandler = overrideHandler;
    }

    public void reset() {
        this.fCurrentState = 1;
        if (this.fSystemId2ContextMap.size() != 0) {
            this.fSystemId2ContextMap.clear();
        }
    }

    public Element transform(String schemaId, Element overrideElement, Element targetSchema) {
        Element transformedSchema;
        boolean hasPerformedTransformations = false;
        try {
            transformedSchema = this.fOverrideTransformationHandler.transform(overrideElement, targetSchema);
        }
        catch (OverrideTransformException e) {
            return targetSchema;
        }
        if (transformedSchema != null) {
            hasPerformedTransformations = true;
        } else {
            transformedSchema = targetSchema;
        }
        String schemaIdString = this.nullToEmptyString(schemaId);
        if (this.checkSchemaDependencies(schemaIdString, overrideElement, transformedSchema, hasPerformedTransformations)) {
            return transformedSchema;
        }
        return null;
    }

    public void addSchemaRoot(String schemaId, Element schemaRoot) {
        String schemaIdString = this.nullToEmptyString(schemaId);
        this.setDocumentMapForSystemId(schemaIdString, this.createDocumentMap(schemaRoot, DocumentContext.IS_ORIGINAL));
    }

    public void checkSchemaRoot(String schemaId, Element decl, Element schemaRoot) {
        String schemaIdString = this.nullToEmptyString(schemaId);
        if (this.includeSchemaDependencies(schemaIdString, schemaRoot, DocumentContext.IS_ORIGINAL)) {
            this.fCurrentState = 1;
            return;
        }
        DocumentContext dCtxt = this.getDocumentMapForSystemId(schemaIdString);
        Iterator mappedRoots = dCtxt.getSchemaArray();
        while (mappedRoots.hasNext()) {
            Element mRoot = (Element)mappedRoots.next();
            if (DocumentContext.IS_ORIGINAL != dCtxt.getSchemaState(mRoot)) continue;
            this.fCurrentState = 3;
            return;
        }
        this.fCurrentState = 4;
        this.fSchemaHandler.reportSchemaError("src-override-collision.1", new Object[]{schemaId, DOMUtil.getLocalName(decl)}, decl);
    }

    public int getCurrentState() {
        return this.fCurrentState;
    }

    public void setOverrideHandler(OverrideTransformer overrideHandler) {
        this.fOverrideTransformationHandler = overrideHandler;
    }

    private DocumentContext createDocumentMap(Element schemaRootElement, Boolean state) {
        DocumentContext dCtxt = new DocumentContext();
        dCtxt.addSchemasToArray(schemaRootElement, state);
        return dCtxt;
    }

    public boolean hasGlobalDecl(Element schemaRoot) {
        return this.hasComponentsTypes(schemaRoot, fGlobalComponentNames);
    }

    public boolean hasCompositionalDecl(Element schemaRoot) {
        return this.hasComponentsTypes(schemaRoot, fCompositeComponentNames);
    }

    private boolean checkSchemaDependencies(String schemaId, Element decl, Element schemaRoot, boolean hasTransformationsOnSchema) {
        Boolean newSchemaState;
        Boolean bl = newSchemaState = hasTransformationsOnSchema ? DocumentContext.IS_TRANSFORMED : DocumentContext.IS_ORIGINAL;
        if (this.includeSchemaDependencies(schemaId, schemaRoot, newSchemaState)) {
            this.fCurrentState = 1;
            return true;
        }
        boolean collisionState = false;
        DocumentContext dCtxt = this.getDocumentMapForSystemId(schemaId);
        Iterator mappedRoots = dCtxt.getSchemaArray();
        while (mappedRoots.hasNext()) {
            Element mRoot = (Element)mappedRoots.next();
            if (this.checkDuplicateElements(dCtxt, mRoot, schemaRoot, newSchemaState)) {
                this.fCurrentState = 3;
                return false;
            }
            collisionState = true;
        }
        if (collisionState) {
            if (!this.hasGlobalDecl(schemaRoot)) {
                dCtxt.addSchemasToArray(schemaRoot);
            } else {
                this.fCurrentState = 4;
                this.fSchemaHandler.reportSchemaError("src-override-collision.2", new Object[]{schemaId}, decl);
                return false;
            }
        }
        this.fCurrentState = 2;
        return true;
    }

    private boolean includeSchemaDependencies(String schemaId, Element schemaRoot, Boolean state) {
        if (!this.isSchemaAlreadyTraversed(schemaId)) {
            this.setDocumentMapForSystemId(schemaId, this.createDocumentMap(schemaRoot, state));
            return true;
        }
        return false;
    }

    private boolean isSchemaAlreadyTraversed(String schemaId) {
        return this.fSystemId2ContextMap.get(schemaId) != null;
    }

    private boolean checkDuplicateElements(DocumentContext dCtxt, Element contextComponent, Element newComponent, Boolean stateNewSchema) {
        Boolean stateCtxtElement = dCtxt.getSchemaState(contextComponent);
        if (stateCtxtElement == DocumentContext.IS_TRANSFORMED && stateNewSchema == DocumentContext.IS_TRANSFORMED) {
            return this.compareComponents(contextComponent, newComponent);
        }
        return stateCtxtElement == DocumentContext.IS_ORIGINAL && stateNewSchema == DocumentContext.IS_ORIGINAL;
    }

    private boolean compareComponents(Element component1, Element component2) {
        component1.normalize();
        component2.normalize();
        return component1.isEqualNode(component2);
    }

    private DocumentContext getDocumentMapForSystemId(String systemId) {
        return (DocumentContext)this.fSystemId2ContextMap.get(systemId);
    }

    private void setDocumentMapForSystemId(String systemId, DocumentContext map) {
        this.fSystemId2ContextMap.put(systemId, map);
    }

    private String nullToEmptyString(String input) {
        return input == null ? "" : input;
    }

    private boolean hasComponentsTypes(Element schemaRoot, String[] types) {
        Element child = DOMUtil.getFirstChildElement(schemaRoot);
        while (child != null) {
            String localName = this.getLocalName(child);
            for (int i = 0; i < types.length; ++i) {
                if (!types[i].equals(localName)) continue;
                return true;
            }
            child = DOMUtil.getNextSiblingElement(child);
        }
        return false;
    }

    private String getLocalName(Node node) {
        String localName = "";
        localName = DOMUtil.getLocalName(node);
        if (localName.indexOf(":") > -1) {
            return localName.split(":")[1];
        }
        return localName;
    }

    private static final class DocumentContext {
        private final ArrayList fRootElementList = new ArrayList();
        private final HashMap fSchema2StateMap = new HashMap();
        private static final Boolean IS_ORIGINAL = Boolean.TRUE;
        private static final Boolean IS_TRANSFORMED = Boolean.FALSE;

        DocumentContext() {
        }

        void addSchemasToArray(Element schemaRoot) {
            this.fRootElementList.add(schemaRoot);
        }

        void addSchemasToArray(Element schemaRoot, Boolean state) {
            this.addSchemasToArray(schemaRoot);
            this.fSchema2StateMap.put(schemaRoot, state);
        }

        Boolean getSchemaState(Element schemaRoot) {
            return (Boolean)this.fSchema2StateMap.get(schemaRoot);
        }

        Iterator getSchemaArray() {
            return this.fRootElementList.iterator();
        }

        void clear() {
            this.fRootElementList.clear();
            this.fSchema2StateMap.clear();
        }
    }
}

