/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.xs;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import org.apache.xerces.impl.xs.assertion.XSAssertImpl;
import org.apache.xerces.impl.xs.traversers.XSDHandler;
import org.apache.xerces.impl.xs.util.XS11TypeHelper;
import org.apache.xerces.util.NamespaceSupport;
import org.apache.xerces.xs.XSModel;
import org.eclipse.wst.xml.xpath2.processor.DefaultDynamicContext;
import org.eclipse.wst.xml.xpath2.processor.DefaultEvaluator;
import org.eclipse.wst.xml.xpath2.processor.DynamicContext;
import org.eclipse.wst.xml.xpath2.processor.JFlexCupParser;
import org.eclipse.wst.xml.xpath2.processor.ResultSequence;
import org.eclipse.wst.xml.xpath2.processor.ResultSequenceFactory;
import org.eclipse.wst.xml.xpath2.processor.StaticContext;
import org.eclipse.wst.xml.xpath2.processor.StaticNameResolver;
import org.eclipse.wst.xml.xpath2.processor.XPathParserException;
import org.eclipse.wst.xml.xpath2.processor.ast.XPath;
import org.eclipse.wst.xml.xpath2.processor.function.FnFunctionLibrary;
import org.eclipse.wst.xml.xpath2.processor.function.XSCtrLibrary;
import org.eclipse.wst.xml.xpath2.processor.internal.Focus;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.XPathNode;
import org.eclipse.wst.xml.xpath2.processor.internal.function.FunctionLibrary;
import org.eclipse.wst.xml.xpath2.processor.internal.types.AnyType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.ElementType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSBoolean;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class AbstractXPath2EngineImpl {
    private DynamicContext fXpath2DynamicContext = null;
    private Document fDomDoc = null;

    public DynamicContext initXPath2DynamicContext(XSModel schema, Document document, Map xpathEngineParams) {
        this.fXpath2DynamicContext = new DefaultDynamicContext(schema, document);
        NamespaceSupport xpath2NamespaceContext = (NamespaceSupport)xpathEngineParams.get("XPATH2_NS_CONTEXT");
        Boolean isCtaEvaluator = (Boolean)xpathEngineParams.get("CTA-EVALUATOR");
        if (isCtaEvaluator != null && isCtaEvaluator.booleanValue()) {
            String[] namespaceBindingInfo = xpath2NamespaceContext.getNamespaceBindingInfo();
            List prefixes = this.getPrefixesXS11CTA(namespaceBindingInfo);
            for (int prfxIdx = 0; prfxIdx < prefixes.size(); ++prfxIdx) {
                String prefix = (String)prefixes.get(prfxIdx);
                this.addNamespaceBindingToXPath2DynamicContext(prefix, this.getURIXS11CTA(prefix, namespaceBindingInfo));
            }
        } else {
            Enumeration currPrefixes = xpath2NamespaceContext.getAllPrefixes();
            while (currPrefixes.hasMoreElements()) {
                String prefix = (String)currPrefixes.nextElement();
                this.addNamespaceBindingToXPath2DynamicContext(prefix, xpath2NamespaceContext.getURI(prefix));
            }
            this.addNamespaceBindingToXPath2DynamicContext("xml", "http://www.w3.org/XML/1998/namespace");
        }
        this.fXpath2DynamicContext.add_function_library((FunctionLibrary)new FnFunctionLibrary());
        this.fXpath2DynamicContext.add_function_library((FunctionLibrary)new XSCtrLibrary());
        this.fDomDoc = document;
        return this.fXpath2DynamicContext;
    }

    protected void addNamespaceBindingToXPath2DynamicContext(String prefix, String uri) {
        this.fXpath2DynamicContext.add_namespace(prefix, uri);
    }

    protected boolean evaluateXPathExpr(XPath xpathObject, Element contextNode) throws Exception {
        StaticNameResolver sc = new StaticNameResolver((StaticContext)this.fXpath2DynamicContext);
        sc.check((XPathNode)xpathObject);
        DefaultEvaluator xpath2Evaluator = null;
        if (contextNode != null) {
            xpath2Evaluator = new DefaultEvaluator(this.fXpath2DynamicContext, this.fDomDoc, (Node)this.fDomDoc.getDocumentElement());
            ResultSequence contextNodeResultSet = ResultSequenceFactory.create_new();
            contextNodeResultSet.add((AnyType)new ElementType(contextNode));
            this.fXpath2DynamicContext.set_focus(new Focus(contextNodeResultSet));
        } else {
            xpath2Evaluator = new DefaultEvaluator(this.fXpath2DynamicContext, null);
        }
        ResultSequence resultSeq = xpath2Evaluator.evaluate((XPathNode)xpathObject);
        boolean result = false;
        if (resultSeq == null) {
            result = false;
        } else if (resultSeq.size() == 1) {
            AnyType rsReturn = resultSeq.get(0);
            if (rsReturn instanceof XSBoolean) {
                XSBoolean returnResultBool = (XSBoolean)rsReturn;
                result = returnResultBool.value();
            } else {
                result = false;
            }
        } else {
            result = false;
        }
        return result;
    }

    protected XPath compileXPathStr(String xpathStr, XSAssertImpl assertImpl, XSDHandler fSchemaHandler, Element schemaContextElem) {
        JFlexCupParser xpathParser = new JFlexCupParser();
        XPath xpathObject = null;
        try {
            xpathObject = xpathParser.parse("boolean(" + xpathStr + ")", true);
        }
        catch (XPathParserException ex) {
            if ("Expression starts with / or //".equals(ex.getMessage())) {
                fSchemaHandler.reportSchemaWarning("cvc-xpath.3.13.4.2b", new Object[]{assertImpl.getTest().getXPathStr(), XS11TypeHelper.getSchemaTypeName(assertImpl.getTypeDefinition())}, schemaContextElem);
            }
            fSchemaHandler.reportSchemaError("cvc-xpath.3.13.4.2a", new Object[]{assertImpl.getTest().getXPathStr(), XS11TypeHelper.getSchemaTypeName(assertImpl.getTypeDefinition())}, schemaContextElem);
        }
        return xpathObject;
    }

    private List getPrefixesXS11CTA(String[] namespaceBindingInfo) {
        ArrayList<String> prefixes = new ArrayList<String>();
        for (int prefixIdx = 0; prefixIdx < namespaceBindingInfo.length && namespaceBindingInfo[prefixIdx] != null; prefixIdx += 2) {
            prefixes.add(namespaceBindingInfo[prefixIdx]);
        }
        return prefixes;
    }

    private String getURIXS11CTA(String prefix, String[] namespaceBindingInfo) {
        String uri = null;
        for (int prefixIdx = 0; prefixIdx < namespaceBindingInfo.length && namespaceBindingInfo[prefixIdx] != null; prefixIdx += 2) {
            if (!prefix.equals(namespaceBindingInfo[prefixIdx])) continue;
            uri = namespaceBindingInfo[prefixIdx + 1];
            break;
        }
        return uri;
    }
}

