/*
 * Decompiled with CFR 0.152.
 */
package com.xsdexplorer.uihelpers;

import com.xsdexplorer.uihelpers.TreeItemPredicate;
import java.util.List;
import java.util.function.Predicate;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.scene.control.CheckBoxTreeItem;
import javafx.scene.control.TreeItem;

public class FilterableTreeItem<T>
extends CheckBoxTreeItem<T> {
    private final ObservableList<TreeItem<T>> sourceList = FXCollections.observableArrayList();
    private final FilteredList<TreeItem<T>> filteredList = new FilteredList(this.sourceList);
    private final ObjectProperty<TreeItemPredicate<T>> predicate = new SimpleObjectProperty();

    public FilterableTreeItem(T t) {
        super(t);
        this.filteredList.predicateProperty().bind((ObservableValue)Bindings.createObjectBinding(() -> {
            Predicate<TreeItem> predicate = treeItem -> {
                if (treeItem instanceof FilterableTreeItem) {
                    FilterableTreeItem filterableTreeItem = (FilterableTreeItem)((Object)((Object)treeItem));
                    filterableTreeItem.setPredicate((TreeItemPredicate)this.predicate.get());
                }
                if (this.predicate.get() == null) {
                    return true;
                }
                if (treeItem.getChildren().size() > 0) {
                    return true;
                }
                return ((TreeItemPredicate)this.predicate.get()).test(this, treeItem.getValue());
            };
            return predicate;
        }, (Observable[])new Observable[]{this.predicate}));
        Bindings.bindContent((List)this.getChildren(), this.getBackingList());
    }

    public ObservableList<TreeItem<T>> getBackingList() {
        return this.filteredList;
    }

    public ObservableList<TreeItem<T>> getInternalChildren() {
        return this.sourceList;
    }

    public final ObjectProperty<TreeItemPredicate<T>> predicateProperty() {
        return this.predicate;
    }

    public final TreeItemPredicate<T> getPredicate() {
        return (TreeItemPredicate)this.predicate.get();
    }

    public final void setPredicate(TreeItemPredicate<T> treeItemPredicate) {
        this.predicate.set(treeItemPredicate);
    }
}

