/*
 * Decompiled with CFR 0.152.
 */
package com.xsdexplorer.tools.gensample;

import javax.xml.stream.XMLStreamException;
import org.codehaus.stax2.XMLStreamWriter2;
import org.codehaus.stax2.util.StreamWriter2Delegate;

public class IndentingXMLStreamWriter
extends StreamWriter2Delegate {
    private String indentStep = "  ";
    private int depth = 0;
    private boolean seenText = false;

    public IndentingXMLStreamWriter(XMLStreamWriter2 xMLStreamWriter2) {
        super(xMLStreamWriter2);
        this.mDelegate2 = xMLStreamWriter2;
    }

    public void setIndentStep(String string) {
        this.indentStep = string;
    }

    private void onStartElement() throws XMLStreamException {
        this.seenText = false;
        if (this.depth > 0) {
            super.writeCharacters("\n");
        }
        this.doIndent();
        ++this.depth;
    }

    private void onEndElement() throws XMLStreamException {
        --this.depth;
        if (!this.seenText) {
            super.writeCharacters("\n");
            this.doIndent();
        }
        this.seenText = false;
    }

    private void onEmptyElement() throws XMLStreamException {
        this.seenText = false;
        if (this.depth > 0) {
            super.writeCharacters("\n");
        }
        this.doIndent();
    }

    private void doIndent() throws XMLStreamException {
        for (int i = 0; i < this.depth; ++i) {
            super.writeCharacters(this.indentStep);
        }
    }

    public void writeStartDocument() throws XMLStreamException {
        super.writeStartDocument();
        super.writeCharacters("\n");
    }

    public void writeStartDocument(String string) throws XMLStreamException {
        super.writeStartDocument(string);
        super.writeCharacters("\n");
    }

    public void writeStartDocument(String string, String string2) throws XMLStreamException {
        super.writeStartDocument(string, string2);
        super.writeCharacters("\n");
    }

    public void writeStartElement(String string) throws XMLStreamException {
        this.onStartElement();
        super.writeStartElement(string);
    }

    public void writeStartElement(String string, String string2) throws XMLStreamException {
        this.onStartElement();
        super.writeStartElement(string, string2);
    }

    public void writeStartElement(String string, String string2, String string3) throws XMLStreamException {
        this.onStartElement();
        super.writeStartElement(string, string2, string3);
    }

    public void writeEmptyElement(String string, String string2) throws XMLStreamException {
        this.onEmptyElement();
        super.writeEmptyElement(string, string2);
    }

    public void writeEmptyElement(String string, String string2, String string3) throws XMLStreamException {
        this.onEmptyElement();
        super.writeEmptyElement(string, string2, string3);
    }

    public void writeEmptyElement(String string) throws XMLStreamException {
        this.onEmptyElement();
        super.writeEmptyElement(string);
    }

    public void writeEndElement() throws XMLStreamException {
        this.onEndElement();
        super.writeEndElement();
    }

    public void writeCharacters(String string) throws XMLStreamException {
        this.seenText = true;
        super.writeCharacters(string);
    }

    public void writeCharacters(char[] cArray, int n, int n2) throws XMLStreamException {
        this.seenText = true;
        super.writeCharacters(cArray, n, n2);
    }

    public void writeCData(String string) throws XMLStreamException {
        this.seenText = true;
        super.writeCData(string);
    }

    public void skipIndentOfClosingTag() {
        this.seenText = true;
    }
}

