/*
 * Decompiled with CFR 0.152.
 */
package com.xsdexplorer.tools.gensample;

import com.xsdexplorer.ExternalEditor;
import com.xsdexplorer.tools.gensample.GenSample;
import com.xsdexplorer.tools.gensample.GenSampleOptionsController;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Optional;
import javafx.event.ActionEvent;
import javafx.fxml.FXMLLoader;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.control.DialogPane;
import javafx.stage.StageStyle;
import org.apache.xerces.xs.XSElementDeclaration;
import org.apache.xerces.xs.XSModel;
import org.apache.xerces.xs.XSNamedMap;

public class GenSampleRunner {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(XSModel xSModel, XSElementDeclaration xSElementDeclaration) {
        block8: {
            XSNamedMap xSNamedMap;
            if (xSElementDeclaration == null) {
                xSNamedMap = xSModel.getComponents((short)2);
                if (xSNamedMap.isEmpty()) {
                    this.showNoElementsError();
                    return;
                }
                xSElementDeclaration = (XSElementDeclaration)xSNamedMap.item(0);
            }
            xSNamedMap = new FXMLLoader();
            xSNamedMap.setLocation(this.getClass().getResource("GenSampleOptions.fxml"));
            try {
                DialogPane dialogPane = (DialogPane)xSNamedMap.load();
                Dialog dialog = new Dialog();
                dialog.initStyle(StageStyle.UTILITY);
                dialog.setDialogPane(dialogPane);
                dialog.setTitle("Generate sample");
                GenSampleOptionsController genSampleOptionsController = (GenSampleOptionsController)xSNamedMap.getController();
                genSampleOptionsController.createGlobalsSelectTree(xSModel, xSElementDeclaration);
                Button button = (Button)dialogPane.lookupButton(ButtonType.OK);
                button.addEventFilter(ActionEvent.ACTION, actionEvent -> {
                    if (!this.isValid(genSampleOptionsController)) {
                        actionEvent.consume();
                    }
                });
                Optional optional = dialog.showAndWait();
                if (!optional.isPresent() || optional.get() != ButtonType.OK) break block8;
                FileWriter fileWriter = this.createWriter(genSampleOptionsController.getOutputFilename());
                if (fileWriter == null) {
                    return;
                }
                try {
                    GenSample genSample = genSampleOptionsController.getOptions().build(xSModel, fileWriter);
                    genSample.generate();
                }
                finally {
                    fileWriter.close();
                }
                new ExternalEditor().openEditor(new File(genSampleOptionsController.getOutputFilename()), 0);
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
    }

    private boolean isValid(GenSampleOptionsController genSampleOptionsController) {
        if (genSampleOptionsController.getOptions().root == null) {
            Alert alert = new Alert(Alert.AlertType.ERROR);
            alert.setTitle("No root element selected");
            alert.setHeaderText("Please select root element");
            alert.showAndWait();
            return false;
        }
        return true;
    }

    private void showNoElementsError() {
        Alert alert = new Alert(Alert.AlertType.ERROR);
        alert.setTitle("No global elements");
        alert.setHeaderText("Cannot generate sample file");
        alert.setContentText("Schema has no global elements defined");
        alert.showAndWait();
    }

    FileWriter createWriter(String string) {
        try {
            return new FileWriter(string);
        }
        catch (IOException iOException) {
            Alert alert = new Alert(Alert.AlertType.ERROR);
            alert.setTitle("Invalid output file");
            alert.setHeaderText("Error creating file " + string);
            alert.showAndWait();
            return null;
        }
    }
}

