/*
 * Decompiled with CFR 0.152.
 */
package com.xsdexplorer.tools.gensample;

import com.xsdexplorer.tools.gensample.GenSample;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.stage.FileChooser;
import javafx.util.StringConverter;
import javafx.util.converter.IntegerStringConverter;
import org.apache.xerces.xs.StringList;
import org.apache.xerces.xs.XSElementDeclaration;
import org.apache.xerces.xs.XSModel;
import org.apache.xerces.xs.XSObject;

public class GenSampleOptionsController {
    @FXML
    private TextField repeatedCountText;
    @FXML
    private CheckBox optCheckBox;
    @FXML
    private CheckBox repeatedChoiceCreateAllBox;
    @FXML
    private TreeView<TreeViewRecord> treeView;
    @FXML
    private Button browseBtn;
    @FXML
    private TextField outputFilename;
    private XSModel model;

    @FXML
    private void initialize() {
        TextFormatter textFormatter = new TextFormatter((StringConverter)new IntegerStringConverter(), (Object)1, change -> Pattern.matches("\\d*", change.getText()) ? change : null);
        this.repeatedCountText.setTextFormatter(textFormatter);
    }

    @FXML
    private void onBrowserBtn() {
        FileChooser fileChooser = new FileChooser();
        fileChooser.getExtensionFilters().addAll((Object[])new FileChooser.ExtensionFilter[]{new FileChooser.ExtensionFilter("XSD Files", new String[]{"*.xsd"}), new FileChooser.ExtensionFilter("Zip Files", new String[]{"*.zip"})});
        File file = fileChooser.showSaveDialog(this.browseBtn.getScene().getWindow());
        if (file != null) {
            this.outputFilename.setText(file.getAbsolutePath());
        }
    }

    public GenSample.GenSampleBuilder getOptions() {
        GenSample.GenSampleBuilder genSampleBuilder = new GenSample.GenSampleBuilder();
        genSampleBuilder.setRepeatedCount(Integer.valueOf(this.repeatedCountText.getText())).setCreateOptional(this.optCheckBox.isSelected()).setRepeatedChoiceCreateAll(this.repeatedChoiceCreateAllBox.isSelected());
        TreeItem treeItem = (TreeItem)this.treeView.getSelectionModel().getSelectedItem();
        genSampleBuilder.setRoot((XSElementDeclaration)((TreeViewRecord)treeItem.getValue()).xsObject);
        return genSampleBuilder;
    }

    public String getOutputFilename() {
        return this.outputFilename.getText();
    }

    public void createGlobalsSelectTree(XSModel xSModel, XSElementDeclaration xSElementDeclaration) {
        this.model = xSModel;
        TreeView<TreeViewRecord> treeView = this.treeView;
        TreeItem treeItem = new TreeItem((Object)new TreeViewRecord("Globals"));
        treeView.setRoot(treeItem);
        treeItem.setExpanded(true);
        StringList stringList = xSModel.getNamespaces();
        for (int i = 0; i < stringList.size(); ++i) {
            String string = (String)stringList.get(i);
            List<XSObject> list = this.getComponentsByNamespace((short)2, string).stream().sorted((xSObject, xSObject2) -> xSObject.getName().compareToIgnoreCase(xSObject2.getName())).toList();
            if (list.isEmpty()) continue;
            TreeItem treeItem2 = new TreeItem((Object)new TreeViewRecord(string == null || string.isEmpty() ? "<no namespace>" : string));
            treeItem2.setExpanded(true);
            treeItem.getChildren().add((Object)treeItem2);
            for (XSObject xSObject3 : list) {
                TreeItem treeItem3 = new TreeItem((Object)new TreeViewRecord(xSObject3.getName(), xSObject3));
                treeItem2.getChildren().add((Object)treeItem3);
                if (xSObject3 != xSElementDeclaration) continue;
                treeView.getSelectionModel().select((Object)treeItem3);
            }
        }
        this.outputFilename.setText(xSElementDeclaration.getName() + ".xml");
    }

    private Collection<XSObject> getComponentsByNamespace(short s, String string) {
        return this.model.getComponentsByNamespace(s, string).values();
    }

    private static class TreeViewRecord {
        String name;
        XSObject xsObject;

        public TreeViewRecord(String string) {
            this.name = string;
        }

        public TreeViewRecord(String string, XSObject xSObject) {
            this.name = string;
            this.xsObject = xSObject;
        }

        public String toString() {
            return this.name;
        }
    }
}

