/*
 * Decompiled with CFR 0.152.
 */
package com.xsdexplorer.tools.gensample;

import com.xsdexplorer.ComplexTypeExtractor;
import com.xsdexplorer.loader.XmlFactory;
import com.xsdexplorer.tools.gensample.IndentingXMLStreamWriter;
import com.xsdexplorer.tools.gensample.SimpleTypeGen;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.xerces.impl.dv.xs.XSSimpleTypeDecl;
import org.apache.xerces.impl.xs.XSComplexTypeDecl;
import org.apache.xerces.xs.StringList;
import org.apache.xerces.xs.XSAttributeUse;
import org.apache.xerces.xs.XSElementDeclaration;
import org.apache.xerces.xs.XSModel;
import org.apache.xerces.xs.XSModelGroup;
import org.apache.xerces.xs.XSObject;
import org.apache.xerces.xs.XSParticle;
import org.apache.xerces.xs.XSTerm;
import org.apache.xerces.xs.XSTypeDefinition;
import org.codehaus.stax2.XMLStreamWriter2;

public class GenSample {
    private XSModel model;
    private IndentingXMLStreamWriter w;
    private GenSampleBuilder options;
    private Set<XSTypeDefinition> processingSet = Collections.newSetFromMap(new IdentityHashMap());
    private SimpleTypeGen simpleTypeGen = new SimpleTypeGen();

    private GenSample(XSModel xSModel, Writer writer, GenSampleBuilder genSampleBuilder) {
        this.model = xSModel;
        this.options = genSampleBuilder;
        this.createForWriter(writer);
    }

    public void generate() {
        XSElementDeclaration xSElementDeclaration = this.options.root;
        try {
            this.writeRootAndNamespaces(xSElementDeclaration, new HashMap<String, String>());
            this.completeTree(xSElementDeclaration);
            this.w.writeEndElement();
        }
        catch (XMLStreamException xMLStreamException) {
            throw new RuntimeException(xMLStreamException);
        }
        finally {
            try {
                this.w.closeCompletely();
            }
            catch (XMLStreamException xMLStreamException) {}
        }
    }

    private void completeTree(XSElementDeclaration xSElementDeclaration) throws XMLStreamException {
        XSTypeDefinition xSTypeDefinition = xSElementDeclaration.getTypeDefinition();
        if (xSTypeDefinition instanceof XSComplexTypeDecl) {
            XSComplexTypeDecl xSComplexTypeDecl = (XSComplexTypeDecl)xSTypeDefinition;
            if (xSComplexTypeDecl.getAbstract()) {
                xSComplexTypeDecl = this.getNonAbstact(xSComplexTypeDecl);
                this.writeXsiTypeAttr(xSComplexTypeDecl);
            }
            this.writeAttributes(xSComplexTypeDecl);
            XSParticle xSParticle = xSComplexTypeDecl.getParticle();
            if (xSParticle == null) {
                if (xSComplexTypeDecl.getSimpleType() != null) {
                    this.w.writeCharacters(this.simpleTypeGen.genValue((XSSimpleTypeDecl)xSComplexTypeDecl.getSimpleType()));
                } else {
                    this.w.skipIndentOfClosingTag();
                }
                return;
            }
            this.processingSet.add(xSTypeDefinition);
            ElementExpander elementExpander = new ElementExpander();
            for (XSElementDeclaration xSElementDeclaration2 : elementExpander.expand(xSParticle)) {
                this.w.writeStartElement(GenSample.wrapNull(xSElementDeclaration2.getNamespace()), xSElementDeclaration2.getName());
                this.completeTree(xSElementDeclaration2);
                this.w.writeEndElement();
            }
            this.processingSet.remove(xSTypeDefinition);
        } else {
            this.w.writeCharacters(this.simpleTypeGen.genValue((XSSimpleTypeDecl)xSTypeDefinition));
        }
    }

    private void writeXsiTypeAttr(XSComplexTypeDecl xSComplexTypeDecl) throws XMLStreamException {
        QName qName = new QName(xSComplexTypeDecl.getNamespace(), xSComplexTypeDecl.getName());
        this.w.writeQNameAttribute("xsi", "http://www.w3.org/2001/XMLSchema-instance", "type", qName);
    }

    private XSComplexTypeDecl getNonAbstact(XSComplexTypeDecl xSComplexTypeDecl) {
        XSObject xSObject = (XSObject)this.getTypes().stream().filter(xSTypeDefinition -> {
            XSComplexTypeDecl xSComplexTypeDecl2;
            return xSTypeDefinition instanceof XSComplexTypeDecl && (xSComplexTypeDecl2 = (XSComplexTypeDecl)xSTypeDefinition).derivedFromType((XSTypeDefinition)xSComplexTypeDecl, (short)0);
        }).findAny().orElseThrow();
        return (XSComplexTypeDecl)xSObject;
    }

    private static <T> Collection<T> castList(Collection collection) {
        return collection;
    }

    private Collection<XSTypeDefinition> getTypes() {
        return GenSample.castList(this.model.getComponents((short)3).values());
    }

    private void writeRootAndNamespaces(XSElementDeclaration xSElementDeclaration, Map<String, String> map) throws XMLStreamException {
        Map<String, String> map2 = this.createNsMap(map);
        for (Map.Entry<String, String> entry : map2.entrySet()) {
            this.w.setPrefix(entry.getKey(), entry.getValue());
        }
        this.w.writeStartElement(GenSample.wrapNull(xSElementDeclaration.getNamespace()), xSElementDeclaration.getName());
        for (Map.Entry<String, String> entry : map2.entrySet()) {
            this.w.writeNamespace(entry.getKey(), entry.getValue());
        }
    }

    private static String wrapNull(String string) {
        return string == null ? "" : string;
    }

    private void writeAttributes(XSComplexTypeDecl xSComplexTypeDecl) throws XMLStreamException {
        List<XSAttributeUse> list = ComplexTypeExtractor.castObjectList(xSComplexTypeDecl.getAttributeUses());
        for (XSAttributeUse xSAttributeUse : list) {
            if (!this.options.createOptional && !xSAttributeUse.getRequired()) continue;
            String string = null;
            string = xSAttributeUse.getConstraintType() != 0 ? xSAttributeUse.getValueConstraintValue().getNormalizedValue() : this.simpleTypeGen.genValue((XSSimpleTypeDecl)xSAttributeUse.getAttrDeclaration().getTypeDefinition());
            this.w.writeAttribute(GenSample.wrapNull(xSAttributeUse.getAttrDeclaration().getNamespace()), xSAttributeUse.getAttrDeclaration().getName(), string);
        }
    }

    private Map<String, String> createNsMap(Map<String, String> map) {
        if (map.values().stream().anyMatch(string -> string.startsWith("n") && string.length() == 2 && Character.isDigit(string.charAt(1)))) {
            map.clear();
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        map.put("http://www.w3.org/XML/1998/namespace", "xml");
        if (this.getTypes().stream().anyMatch(xSTypeDefinition -> {
            XSComplexTypeDecl xSComplexTypeDecl;
            return xSTypeDefinition instanceof XSComplexTypeDecl && (xSComplexTypeDecl = (XSComplexTypeDecl)xSTypeDefinition).getAbstract();
        })) {
            map.put("http://www.w3.org/2001/XMLSchema-instance", "xsi");
            hashMap.put("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        }
        StringList stringList = this.model.getNamespaces();
        int n = stringList.getLength();
        int n2 = 1;
        for (int i = 0; i < n; ++i) {
            String string2 = stringList.item(i);
            if (string2 == null || string2.equals("http://www.w3.org/2001/XMLSchema")) continue;
            Object object = map.get(string2);
            if (object == null || ((String)object).equals("")) {
                object = "n" + n2++;
            }
            hashMap.put((String)object, string2);
        }
        return hashMap;
    }

    private void createForWriter(Writer writer) {
        try {
            XMLStreamWriter2 xMLStreamWriter2 = (XMLStreamWriter2)XmlFactory.outputFactory.createXMLStreamWriter(writer);
            this.w = new IndentingXMLStreamWriter(xMLStreamWriter2);
            this.w.writeStartDocument();
        }
        catch (XMLStreamException xMLStreamException) {
            throw new RuntimeException(xMLStreamException);
        }
    }

    public static class GenSampleBuilder {
        boolean createOptional = true;
        boolean repeatedChoiceCreateAll = true;
        int repeatedCount = 1;
        XSElementDeclaration root;

        public GenSampleBuilder setCreateOptional(boolean bl) {
            this.createOptional = bl;
            return this;
        }

        public GenSampleBuilder setRepeatedCount(int n) {
            this.repeatedCount = n;
            return this;
        }

        public GenSampleBuilder setRoot(XSElementDeclaration xSElementDeclaration) {
            this.root = xSElementDeclaration;
            return this;
        }

        public GenSampleBuilder setRepeatedChoiceCreateAll(boolean bl) {
            this.repeatedChoiceCreateAll = bl;
            return this;
        }

        public GenSample build(XSModel xSModel, Writer writer) {
            return new GenSample(xSModel, writer, this);
        }
    }

    private class ElementExpander {
        List<XSElementDeclaration> ret = new ArrayList<XSElementDeclaration>();

        private ElementExpander() {
        }

        void doExpand(XSParticle xSParticle) {
            if (xSParticle.getMinOccurs() == 0 && !GenSample.this.options.createOptional) {
                return;
            }
            int n = Math.max(xSParticle.getMinOccurs(), 1);
            int n2 = xSParticle.getMaxOccursUnbounded() ? GenSample.this.options.repeatedCount : xSParticle.getMaxOccurs();
            int n3 = Math.max(n, n2);
            block8: for (int i = 0; i < n3; ++i) {
                XSTerm xSTerm = xSParticle.getTerm();
                switch (xSTerm.getType()) {
                    case 7: {
                        XSModelGroup xSModelGroup = (XSModelGroup)xSTerm;
                        List<Object> list = ComplexTypeExtractor.castObjectList(xSModelGroup.getParticles());
                        switch (xSModelGroup.getCompositor()) {
                            case 1: 
                            case 3: {
                                for (XSParticle xSParticle2 : list) {
                                    this.doExpand(xSParticle2);
                                }
                                continue block8;
                            }
                            case 2: {
                                if (xSParticle.getMaxOccursUnbounded() && GenSample.this.options.repeatedChoiceCreateAll) {
                                    for (int j = 0; j < list.size(); ++j) {
                                        this.doExpand((XSParticle)list.get(j));
                                    }
                                    continue block8;
                                }
                                if (list.size() <= 0) continue block8;
                                this.doExpand((XSParticle)list.get(0));
                                continue block8;
                            }
                            default: {
                                throw new RuntimeException("Unknown compositor!");
                            }
                        }
                    }
                    case 2: {
                        List<Object> list;
                        XSModelGroup xSModelGroup = (XSElementDeclaration)xSTerm;
                        if (xSModelGroup.getAbstract()) {
                            list = ComplexTypeExtractor.castObjectList(GenSample.this.model.getSubstitutionGroup((XSElementDeclaration)xSModelGroup));
                            xSModelGroup = (XSElementDeclaration)list.get(0);
                        }
                        if (GenSample.this.processingSet.contains(xSModelGroup.getTypeDefinition())) continue block8;
                        this.ret.add((XSElementDeclaration)xSModelGroup);
                        continue block8;
                    }
                }
            }
        }

        public List<XSElementDeclaration> expand(XSParticle xSParticle) {
            this.doExpand(xSParticle);
            return this.ret;
        }
    }
}

