/*
 * Decompiled with CFR 0.152.
 */
package com.xsdexplorer.settings;

import com.xsdexplorer.ExternalEditor;
import java.io.File;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.Window;

public class SettingsDialog {
    private final TextField textEdit = new TextField();

    public void showSettingsDialog(Stage stage) {
        Dialog dialog = new Dialog();
        dialog.initStyle(StageStyle.UTILITY);
        dialog.setTitle("Settings");
        VBox vBox = new VBox();
        vBox.setPadding(new Insets(16.0));
        dialog.getDialogPane().setContent((Node)vBox);
        HBox hBox = this.createEditorPanel(stage);
        vBox.getChildren().add((Object)hBox);
        ButtonType buttonType = new ButtonType("OK", ButtonBar.ButtonData.OK_DONE);
        ButtonType buttonType3 = new ButtonType("Close", ButtonBar.ButtonData.CANCEL_CLOSE);
        dialog.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{buttonType, buttonType3});
        dialog.setResultConverter(buttonType2 -> {
            if (buttonType2 == buttonType) {
                ExternalEditor.setCurrentEditor(this.textEdit.getText());
            }
            return null;
        });
        dialog.showAndWait();
    }

    private HBox createEditorPanel(Stage stage) {
        FileChooser fileChooser = new FileChooser();
        String string = ExternalEditor.getCurrentEditor();
        File file = new File(string);
        File file2 = file.getParentFile();
        if (file2 != null) {
            fileChooser.setInitialDirectory(file2);
        }
        fileChooser.setInitialFileName(file.getName());
        fileChooser.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter("Executable", new String[]{"*.exe"}));
        HBox hBox = new HBox(5.0);
        hBox.setAlignment(Pos.BASELINE_CENTER);
        Label label = new Label("External editor:");
        this.textEdit.setText(string);
        Button button = new Button("Browse");
        button.setOnAction(actionEvent -> {
            File file = fileChooser.showOpenDialog((Window)stage);
            if (file != null) {
                this.textEdit.setText(file.getAbsolutePath());
            }
        });
        hBox.getChildren().addAll((Object[])new Node[]{label, button, this.textEdit});
        return hBox;
    }
}

