/*
 * Decompiled with CFR 0.152.
 */
package com.xsdexplorer.loader;

import com.google.common.base.Preconditions;
import com.xsdexplorer.loader.XmlFactory;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.codehaus.stax2.XMLStreamReader2;

public class XsdInfoLoader {
    private boolean isXsd11;
    private Map<String, String> nsContext = new HashMap<String, String>();
    private FormDefault attrFormDefault = FormDefault.unqualified;
    private FormDefault elementFormDefault = FormDefault.unqualified;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getSchemaInfo(File file) {
        XMLStreamReader2 xMLStreamReader2 = null;
        try {
            xMLStreamReader2 = XmlFactory.factory.createXMLStreamReader(file);
            this.getSchemaInfo(xMLStreamReader2);
        }
        catch (Exception exception) {
            System.err.println("Warning in detecting xsd version: " + exception.getMessage());
        }
        finally {
            try {
                if (xMLStreamReader2 != null) {
                    xMLStreamReader2.close();
                }
            }
            catch (XMLStreamException xMLStreamException) {}
        }
    }

    public void getSchemaInfo(XMLStreamReader2 xMLStreamReader2) throws XMLStreamException {
        this.readToSchemaRoot((XMLStreamReader)xMLStreamReader2);
        this.collectFromSchemaRoot((XMLStreamReader)xMLStreamReader2);
    }

    private void readToSchemaRoot(XMLStreamReader xMLStreamReader) throws XMLStreamException {
        while (xMLStreamReader.hasNext()) {
            int n = xMLStreamReader.next();
            if (n != 1) continue;
            Preconditions.checkState((boolean)xMLStreamReader.getLocalName().equals("schema"), (Object)"Not a schema document!)");
            return;
        }
        throw new IllegalStateException("Not a schema document!");
    }

    private void collectFromSchemaRoot(XMLStreamReader xMLStreamReader) {
        String string;
        if (!this.isXsd11) {
            string = xMLStreamReader.getAttributeValue("http://www.w3.org/2007/XMLSchema-versioning", "minVersion");
            this.isXsd11 = "1.1".equals(string);
        }
        this.collectNamespaces(xMLStreamReader);
        string = xMLStreamReader.getAttributeValue(null, "attributeFormDefault");
        if (string != null) {
            this.attrFormDefault = FormDefault.valueOf(string);
        }
        if ((string = xMLStreamReader.getAttributeValue(null, "elementFormDefault")) != null) {
            this.elementFormDefault = FormDefault.valueOf(string);
        }
    }

    private void collectNamespaces(XMLStreamReader xMLStreamReader) {
        int n = xMLStreamReader.getNamespaceCount();
        for (int i = 0; i < n; ++i) {
            this.nsContext.put(xMLStreamReader.getNamespaceURI(i), xMLStreamReader.getNamespacePrefix(i));
        }
    }

    public boolean isXsd11() {
        return this.isXsd11;
    }

    public Map<String, String> getNsContext() {
        return this.nsContext;
    }

    public FormDefault getAttrFormDefault() {
        return this.attrFormDefault;
    }

    public FormDefault getElementFormDefault() {
        return this.elementFormDefault;
    }

    public static enum FormDefault {
        qualified,
        unqualified;

    }
}

