/*
 * Decompiled with CFR 0.152.
 */
package com.xsdexplorer.loader;

import com.google.common.base.Preconditions;
import com.xsdexplorer.LogView;
import com.xsdexplorer.loader.EntityResolverImpl;
import com.xsdexplorer.loader.FromDirectory;
import com.xsdexplorer.loader.FromZip;
import com.xsdexplorer.loader.XsdInfoLoader;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import org.apache.xerces.impl.Constants;
import org.apache.xerces.impl.xs.SchemaGrammar;
import org.apache.xerces.impl.xs.XMLSchemaLoader;
import org.apache.xerces.impl.xs.XSAnnotationImpl;
import org.apache.xerces.impl.xs.XSAttributeDecl;
import org.apache.xerces.impl.xs.XSAttributeGroupDecl;
import org.apache.xerces.impl.xs.XSElementDecl;
import org.apache.xerces.impl.xs.XSGroupDecl;
import org.apache.xerces.impl.xs.XSNotationDecl;
import org.apache.xerces.impl.xs.util.XSGrammarPool;
import org.apache.xerces.util.SymbolTable;
import org.apache.xerces.xni.grammars.Grammar;
import org.apache.xerces.xni.grammars.XMLGrammarDescription;
import org.apache.xerces.xni.parser.XMLParseException;
import org.apache.xerces.xs.XSModel;
import org.apache.xerces.xs.XSNamedMap;
import org.apache.xerces.xs.XSObjectList;
import org.apache.xerces.xs.XSTypeDefinition;
import org.w3c.dom.DOMError;
import org.w3c.dom.DOMErrorHandler;
import org.w3c.dom.DOMLocator;

public class SchemaLoader {
    public static final String XML_SCHEMA_VERSION = "http://apache.org/xml/properties/validation/schema/version";
    private MyGrammarMerger pool;
    private final StringProperty messages = new SimpleStringProperty((Object)this, "messages", "");
    private XsdInfoLoader xsdInfo = new XsdInfoLoader();
    private SymbolTable symTable;

    public SchemaLoader() {
        this.pool = new MyGrammarMerger();
    }

    public XSModel loadSchemaFile(File file) throws IOException {
        this.loadSchema(file);
        return this.pool.toXSModel(this.xsdInfo.isXsd11() ? (short)4 : 1);
    }

    public void loadSchema(File file) throws IOException {
        XMLSchemaLoader xMLSchemaLoader = new XMLSchemaLoader();
        xMLSchemaLoader.setParameter("http://apache.org/xml/features/validation/schema-full-checking", (Object)true);
        xMLSchemaLoader.setParameter("error-handler", (Object)new DOMErrorHandlerImpl());
        EntityResolverImpl entityResolverImpl = new EntityResolverImpl();
        xMLSchemaLoader.setParameter("http://apache.org/xml/properties/internal/entity-resolver", (Object)entityResolverImpl);
        xMLSchemaLoader.setParameter("http://apache.org/xml/properties/internal/grammar-pool", (Object)this.pool);
        Preconditions.checkState((!this.pool.inXmlValidationState ? 1 : 0) != 0, (Object)"internal error - is loaded in xml validation state");
        if (file.isFile()) {
            if (file.getName().endsWith(".xsd")) {
                this.xsdInfo.getSchemaInfo(file);
                this.setXsd11IfNeeded(xMLSchemaLoader);
                xMLSchemaLoader.loadURI(file.toURI().getRawPath());
            } else if (file.getName().endsWith(".zip")) {
                FromZip fromZip = new FromZip(file);
                entityResolverImpl.setFileContentMap(fromZip.getMapOfXsdStrings());
                List<Path> list = new FromDirectory(fromZip.getMapOfXsdStrings(), this.xsdInfo).extractTopLevel();
                this.addInfoMessage("top level files in arhive: " + fromZip.relativize(list));
                this.setXsd11IfNeeded(xMLSchemaLoader);
                for (Path path : list) {
                    xMLSchemaLoader.loadGrammar(entityResolverImpl.getSourceFromPath(path));
                }
            }
        } else if (file.isDirectory()) {
            Instant instant = Instant.now();
            List<Path> list = new FromDirectory(file, this.xsdInfo).extractTopLevel();
            long l = Duration.between(instant, Instant.now()).toMillis();
            System.out.println("Directory load top level xsd files: " + l + "ms - " + list);
            this.addInfoMessage("top level files in directory: " + list);
            this.setXsd11IfNeeded(xMLSchemaLoader);
            for (Path path : list) {
                xMLSchemaLoader.loadURI(path.toUri().getRawPath());
            }
            l = Duration.between(instant, Instant.now()).toMillis();
            System.out.println("Directory load total: " + l + "ms");
        } else {
            throw new IOException("Cannot read file " + file);
        }
        this.symTable = (SymbolTable)xMLSchemaLoader.getParameter("http://apache.org/xml/properties/internal/symbol-table");
    }

    private void setXsd11IfNeeded(XMLSchemaLoader xMLSchemaLoader) {
        if (this.xsdInfo.isXsd11()) {
            this.addInfoMessage("xsd version 1.1 is detected and will be used for validation");
            xMLSchemaLoader.setParameter(XML_SCHEMA_VERSION, (Object)Constants.W3C_XML_SCHEMA11_NS_URI);
        }
    }

    private void addInfoMessage(String string) {
        this.messages.set((Object)LogView.Kind.INFO.formatMessage(string));
    }

    private void addErrorMessage(String string) {
        this.messages.set((Object)LogView.Kind.ERROR.formatMessage(string));
    }

    public XSModel getXSModel() {
        return this.pool.toXSModel(this.xsdInfo.isXsd11() ? (short)4 : 1);
    }

    public XSGrammarPool getPool() {
        this.pool.enableXmlValidationSate();
        return this.pool;
    }

    public SymbolTable getSymbolTable() {
        return this.symTable;
    }

    public boolean isXsd11() {
        return this.xsdInfo.isXsd11();
    }

    public StringProperty messageProperty() {
        return this.messages;
    }

    private static final class MyGrammarMerger
    extends XSGrammarPool {
        private boolean inXmlValidationState = false;

        MyGrammarMerger() {
        }

        public void enableXmlValidationSate() {
            this.inXmlValidationState = true;
        }

        public void putGrammar(Grammar grammar) {
            if (this.inXmlValidationState) {
                return;
            }
            SchemaGrammar schemaGrammar = this.toSchemaGrammar(super.getGrammar(grammar.getGrammarDescription()));
            if (schemaGrammar != null) {
                SchemaGrammar schemaGrammar2 = this.toSchemaGrammar(grammar);
                if (schemaGrammar2 != null) {
                    this.mergeSchemaGrammars(schemaGrammar, schemaGrammar2);
                }
            } else {
                super.putGrammar(grammar);
            }
        }

        private SchemaGrammar toSchemaGrammar(Grammar grammar) {
            return grammar instanceof SchemaGrammar ? (SchemaGrammar)grammar : null;
        }

        private void mergeSchemaGrammars(SchemaGrammar schemaGrammar, SchemaGrammar schemaGrammar2) {
            XSElementDecl xSElementDecl;
            int n;
            XSNamedMap xSNamedMap = schemaGrammar2.getComponents((short)2);
            int n2 = xSNamedMap.getLength();
            for (n = 0; n < n2; ++n) {
                xSElementDecl = (XSElementDecl)xSNamedMap.item(n);
                if (schemaGrammar.getGlobalElementDecl(xSElementDecl.getName()) != null) continue;
                schemaGrammar.addGlobalElementDecl(xSElementDecl);
            }
            xSNamedMap = schemaGrammar2.getComponents((short)1);
            n2 = xSNamedMap.getLength();
            for (n = 0; n < n2; ++n) {
                xSElementDecl = (XSAttributeDecl)xSNamedMap.item(n);
                if (schemaGrammar.getGlobalAttributeDecl(xSElementDecl.getName()) != null) continue;
                schemaGrammar.addGlobalAttributeDecl((XSAttributeDecl)xSElementDecl);
            }
            xSNamedMap = schemaGrammar2.getComponents((short)3);
            n2 = xSNamedMap.getLength();
            for (n = 0; n < n2; ++n) {
                xSElementDecl = (XSTypeDefinition)xSNamedMap.item(n);
                if (schemaGrammar.getGlobalTypeDecl(xSElementDecl.getName()) != null) continue;
                schemaGrammar.addGlobalTypeDecl((XSTypeDefinition)xSElementDecl);
            }
            xSNamedMap = schemaGrammar2.getComponents((short)5);
            n2 = xSNamedMap.getLength();
            for (n = 0; n < n2; ++n) {
                xSElementDecl = (XSAttributeGroupDecl)xSNamedMap.item(n);
                if (schemaGrammar.getGlobalAttributeGroupDecl(xSElementDecl.getName()) != null) continue;
                schemaGrammar.addGlobalAttributeGroupDecl((XSAttributeGroupDecl)xSElementDecl);
            }
            xSNamedMap = schemaGrammar2.getComponents((short)7);
            n2 = xSNamedMap.getLength();
            for (n = 0; n < n2; ++n) {
                xSElementDecl = (XSGroupDecl)xSNamedMap.item(n);
                if (schemaGrammar.getGlobalGroupDecl(xSElementDecl.getName()) != null) continue;
                schemaGrammar.addGlobalGroupDecl((XSGroupDecl)xSElementDecl);
            }
            xSNamedMap = schemaGrammar2.getComponents((short)11);
            n2 = xSNamedMap.getLength();
            for (n = 0; n < n2; ++n) {
                xSElementDecl = (XSNotationDecl)xSNamedMap.item(n);
                if (schemaGrammar.getGlobalNotationDecl(xSElementDecl.getName()) != null) continue;
                schemaGrammar.addGlobalNotationDecl((XSNotationDecl)xSElementDecl);
            }
            XSObjectList xSObjectList = schemaGrammar2.getAnnotations();
            n2 = xSObjectList.getLength();
            for (int i = 0; i < n2; ++i) {
                schemaGrammar.addAnnotation((XSAnnotationImpl)xSObjectList.item(i));
            }
        }

        public boolean containsGrammar(XMLGrammarDescription xMLGrammarDescription) {
            return this.inXmlValidationState ? Boolean.valueOf(super.containsGrammar(xMLGrammarDescription)) : null;
        }

        public Grammar getGrammar(XMLGrammarDescription xMLGrammarDescription) {
            return this.inXmlValidationState ? super.getGrammar(xMLGrammarDescription) : null;
        }

        public Grammar retrieveGrammar(XMLGrammarDescription xMLGrammarDescription) {
            return this.getGrammar(xMLGrammarDescription);
        }

        public Grammar[] retrieveInitialGrammarSet(String string) {
            return new Grammar[0];
        }
    }

    private class DOMErrorHandlerImpl
    implements DOMErrorHandler {
        private DOMErrorHandlerImpl() {
        }

        @Override
        public boolean handleError(DOMError dOMError) {
            XMLParseException xMLParseException;
            Object object;
            boolean bl = dOMError.getSeverity() == 3;
            DOMLocator dOMLocator = dOMError.getLocation();
            String string = "";
            if (dOMLocator != null) {
                object = dOMLocator.getUri();
                if (object != null) {
                    if (((String)object).startsWith("file://")) {
                        object = new File(((String)object).substring(7)).getAbsolutePath();
                    }
                    object = (String)object + ": ";
                } else {
                    object = "";
                }
                string = String.format("%sline %d, column :%d%s", object, dOMLocator.getLineNumber(), dOMLocator.getColumnNumber(), dOMLocator.getRelatedNode() != null ? " [" + dOMLocator.getRelatedNode().getNodeName() + "]" : "");
            }
            object = string + ": " + dOMError.getMessage();
            SchemaLoader.this.addErrorMessage((String)object);
            Object object2 = dOMError.getRelatedException();
            if (object2 instanceof XMLParseException && (xMLParseException = (XMLParseException)object2).getException() != null) {
                xMLParseException.getException().printStackTrace();
            }
            if (bl) {
                throw new RuntimeException((String)object);
            }
            return true;
        }
    }
}

