/*
 * Decompiled with CFR 0.152.
 */
package com.xsdexplorer.loader;

import com.google.common.graph.Graph;
import com.google.common.graph.GraphBuilder;
import com.google.common.graph.Graphs;
import com.google.common.graph.MutableGraph;
import com.xsdexplorer.LogView;
import com.xsdexplorer.XsdExplorer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.xerces.impl.xs.SchemaGrammar;
import org.apache.xerces.impl.xs.XSComplexTypeDecl;
import org.apache.xerces.impl.xs.XSElementDecl;
import org.apache.xerces.xs.XSElementDeclaration;
import org.apache.xerces.xs.XSModel;
import org.apache.xerces.xs.XSModelGroup;
import org.apache.xerces.xs.XSNamedMap;
import org.apache.xerces.xs.XSObject;
import org.apache.xerces.xs.XSObjectList;
import org.apache.xerces.xs.XSParticle;
import org.apache.xerces.xs.XSTerm;
import org.apache.xerces.xs.XSTypeDefinition;

public class RootSelector {
    private XSModel model;
    private MutableGraph<XSObject> graph;
    private IdentityHashMap<XSObject, MutableInt> inlineElementCount = new IdentityHashMap();
    private List<XSElementDecl> globals = new ArrayList<XSElementDecl>();

    public RootSelector(XSModel xSModel) {
        this.model = xSModel;
    }

    /*
     * WARNING - void declaration
     */
    public XSElementDeclaration selectRoot() {
        void var7_13;
        XSTypeDefinition xSTypeDefinition;
        XSNamedMap xSNamedMap = this.model.getComponents((short)2);
        if (xSNamedMap.isEmpty()) {
            return null;
        }
        if (xSNamedMap.size() == 1) {
            return (XSElementDeclaration)xSNamedMap.item(0);
        }
        this.graph = GraphBuilder.directed().allowsSelfLoops(false).build();
        for (int i = 0; i < xSNamedMap.getLength(); ++i) {
            XSElementDecl xSElementDecl = (XSElementDecl)xSNamedMap.item(i);
            this.fillGlobalsElement(xSElementDecl);
        }
        XSNamedMap xSNamedMap2 = this.model.getComponents((short)3);
        for (int i = 0; i < xSNamedMap2.getLength(); ++i) {
            xSTypeDefinition = (XSTypeDefinition)xSNamedMap2.item(i);
            if (SchemaGrammar.isAnyType((XSTypeDefinition)xSTypeDefinition) || !(xSTypeDefinition instanceof XSComplexTypeDecl)) continue;
            this.fillGlobalType((XSComplexTypeDecl)xSTypeDefinition);
        }
        this.removeSingleNodes();
        System.out.println("Graph with " + this.graph.nodes().size() + " nodes, " + this.graph.edges().size() + " edges");
        ArrayList<XSElementDeclaration> arrayList = new ArrayList<XSElementDeclaration>();
        xSTypeDefinition = Graphs.copyOf(this.graph);
        Graph graph = Graphs.transpose(this.graph);
        for (XSElementDeclaration object2 : this.globals) {
            Object object;
            if (!this.graph.nodes().contains(object2)) continue;
            boolean bl = this.graph.inDegree((Object)object2) == 0;
            Set set = Graphs.reachableNodes(this.graph, (Object)object2);
            if (!bl && set.containsAll((Collection<?>)(object = Graphs.reachableNodes((Graph)graph, (Object)object2).stream().filter(xSObject -> xSObject instanceof XSElementDeclaration).toList()))) {
                bl = true;
            }
            if (bl) {
                arrayList.add(object2);
            }
            object = set.iterator();
            while (object.hasNext()) {
                XSObject xSObject2 = (XSObject)object.next();
                this.graph.removeNode((Object)xSObject2);
            }
        }
        System.out.println("Topl level nodes: " + arrayList);
        int n = 0;
        Object var7_12 = null;
        for (XSElementDeclaration xSElementDeclaration : this.globals) {
            int n2;
            if (arrayList.contains(xSElementDeclaration)) {
                Set set = Graphs.reachableNodes((Graph)xSTypeDefinition, (Object)xSElementDeclaration);
                int n3 = set.stream().mapToInt(this::getElementCount).sum();
                if (n3 <= n) continue;
                n = n3;
                XSElementDeclaration xSElementDeclaration2 = xSElementDeclaration;
                continue;
            }
            if (xSTypeDefinition.nodes().contains(xSElementDeclaration) || (n2 = this.getElementCount((XSObject)xSElementDeclaration)) <= n) continue;
            n = n2;
            XSElementDeclaration xSElementDeclaration3 = xSElementDeclaration;
        }
        if (var7_13 != null) {
            XsdExplorer.addLogViewMessage(LogView.Kind.INFO, "root detected: " + var7_13.getName() + " (contains " + n + " child elements)");
            return var7_13;
        }
        return (XSElementDeclaration)xSNamedMap.item(0);
    }

    private void removeSingleNodes() {
        ArrayList arrayList = new ArrayList(this.graph.nodes());
        for (XSObject xSObject : arrayList) {
            if (this.graph.degree((Object)xSObject) != 0) continue;
            this.graph.removeNode((Object)xSObject);
        }
    }

    private List<XSParticle> groupParticles(XSModelGroup xSModelGroup) {
        return xSModelGroup.getParticles();
    }

    private List<XSElementDeclaration> getSubstitutionGroup(XSElementDeclaration xSElementDeclaration) {
        XSObjectList xSObjectList = this.model.getSubstitutionGroup(xSElementDeclaration);
        return xSObjectList == null ? Collections.emptyList() : xSObjectList;
    }

    private void fillGlobalsElement(XSElementDecl xSElementDecl) {
        XSParticle xSParticle;
        XSTypeDefinition xSTypeDefinition = xSElementDecl.getTypeDefinition();
        if (xSTypeDefinition instanceof XSComplexTypeDecl) {
            XSComplexTypeDecl xSComplexTypeDecl = (XSComplexTypeDecl)xSTypeDefinition;
            v0 = xSComplexTypeDecl.getParticle();
        } else {
            v0 = xSParticle = null;
        }
        if (xSParticle == null) {
            return;
        }
        this.globals.add(xSElementDecl);
        if (!xSTypeDefinition.getAnonymous()) {
            this.graph.putEdge((Object)xSElementDecl, (Object)xSTypeDefinition);
            return;
        }
        this.processType((XSObject)xSElementDecl, (XSComplexTypeDecl)xSTypeDefinition);
    }

    private void fillGlobalType(XSComplexTypeDecl xSComplexTypeDecl) {
        XSParticle xSParticle = xSComplexTypeDecl.getParticle();
        if (xSParticle == null) {
            return;
        }
        this.processType((XSObject)xSComplexTypeDecl, xSComplexTypeDecl);
    }

    private void processType(XSObject xSObject, XSComplexTypeDecl xSComplexTypeDecl) {
        XSParticle xSParticle;
        XSComplexTypeDecl xSComplexTypeDecl2;
        XSParticle xSParticle2 = xSComplexTypeDecl.getParticle();
        XSTypeDefinition xSTypeDefinition = xSComplexTypeDecl.getBaseType();
        if (xSTypeDefinition instanceof XSComplexTypeDecl) {
            xSComplexTypeDecl2 = (XSComplexTypeDecl)xSTypeDefinition;
            v0 = xSComplexTypeDecl2.getParticle();
        } else {
            v0 = xSParticle = null;
        }
        if (!SchemaGrammar.isAnyType((XSTypeDefinition)xSTypeDefinition) && xSParticle != null) {
            this.graph.putEdge((Object)xSObject, (Object)xSTypeDefinition);
            if (xSComplexTypeDecl.getDerivationMethod() == 2 || xSParticle == xSParticle2) {
                return;
            }
        }
        xSComplexTypeDecl2 = (XSModelGroup)xSParticle2.getTerm();
        List<XSParticle> list = this.groupParticles((XSModelGroup)xSComplexTypeDecl2);
        for (XSParticle xSParticle3 : list) {
            if (xSParticle3 == xSParticle) continue;
            this.processTerm(xSObject, xSParticle3.getTerm());
        }
    }

    private void incInlineElements(XSObject xSObject2) {
        this.inlineElementCount.computeIfAbsent(xSObject2, xSObject -> new MutableInt()).increment();
    }

    private int getElementCount(XSObject xSObject) {
        MutableInt mutableInt = this.inlineElementCount.get(xSObject);
        return mutableInt == null ? 0 : mutableInt.getValue();
    }

    private void processTerm(XSObject xSObject, XSTerm xSTerm) {
        if (xSTerm.getType() == 2) {
            XSParticle xSParticle;
            boolean bl;
            XSElementDecl xSElementDecl = (XSElementDecl)xSTerm;
            this.incInlineElements(xSObject);
            boolean bl2 = bl = xSElementDecl.getScope() == 1;
            if (bl) {
                if (xSObject != xSTerm) {
                    this.graph.putEdge((Object)xSObject, (Object)xSTerm);
                }
                for (XSElementDeclaration xSElementDeclaration : this.getSubstitutionGroup((XSElementDeclaration)xSElementDecl)) {
                    if (xSObject == xSElementDeclaration) continue;
                    this.graph.putEdge((Object)xSObject, (Object)xSElementDeclaration);
                }
                return;
            }
            XSTypeDefinition xSTypeDefinition = xSElementDecl.getTypeDefinition();
            if (xSTypeDefinition instanceof XSComplexTypeDecl) {
                XSComplexTypeDecl xSComplexTypeDecl = (XSComplexTypeDecl)xSTypeDefinition;
                v1 = xSComplexTypeDecl.getParticle();
            } else {
                v1 = xSParticle = null;
            }
            if (xSParticle == null) {
                return;
            }
            if (!xSTypeDefinition.getAnonymous()) {
                if (xSObject != xSTypeDefinition) {
                    this.graph.putEdge((Object)xSObject, (Object)xSTypeDefinition);
                }
                return;
            }
            this.processType(xSObject, (XSComplexTypeDecl)xSTypeDefinition);
        } else if (xSTerm.getType() == 7) {
            XSModelGroup xSModelGroup = (XSModelGroup)xSTerm;
            List<XSParticle> list = this.groupParticles(xSModelGroup);
            for (XSParticle xSParticle : list) {
                this.processTerm(xSObject, xSParticle.getTerm());
            }
        }
    }
}

