/*
 * Decompiled with CFR 0.152.
 */
package com.xsdexplorer.loader;

import com.google.common.io.ByteStreams;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class FromZip {
    private Map<Path, byte[]> mapOfXsdStrings = new HashMap<Path, byte[]>();
    private Path basePath;

    FromZip(byte[] byArray) {
        this.openZip(new ByteArrayInputStream(byArray));
    }

    public FromZip(File file) {
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            this.openZip(fileInputStream);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    private void openZip(InputStream inputStream) {
        this.basePath = Paths.get(System.getProperty("user.dir"), new String[0]);
        try (ZipInputStream zipInputStream = new ZipInputStream(inputStream);){
            ZipEntry zipEntry;
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                String string;
                if (zipEntry.isDirectory() || !(string = zipEntry.getName()).endsWith(".xsd")) continue;
                byte[] byArray = ByteStreams.toByteArray((InputStream)zipInputStream);
                this.mapOfXsdStrings.put(this.basePath.resolve(string), byArray);
            }
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public Path getBasePath() {
        return this.basePath;
    }

    public Map<Path, byte[]> getMapOfXsdStrings() {
        return this.mapOfXsdStrings;
    }

    public List<Path> relativize(List<Path> list) {
        return list.stream().map(path -> this.basePath.relativize((Path)path)).toList();
    }
}

