/*
 * Decompiled with CFR 0.152.
 */
package com.xsdexplorer.loader;

import com.google.common.graph.Graph;
import com.google.common.graph.GraphBuilder;
import com.google.common.graph.Graphs;
import com.google.common.graph.MutableGraph;
import com.xsdexplorer.loader.XmlFactory;
import com.xsdexplorer.loader.XsdInfoLoader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.stream.XMLStreamException;
import org.codehaus.stax2.XMLStreamReader2;

public class FromDirectory {
    List<Path> files;
    private MutableGraph<Path> graph;
    private ArrayList<Path> topLevel = new ArrayList();
    private ReaderCreator xmlReaderCreator;
    private XsdInfoLoader xsdInfo;

    FromDirectory(File file, XsdInfoLoader xsdInfoLoader) throws IOException {
        this.xsdInfo = xsdInfoLoader;
        try (Stream<Path> stream = Files.walk(file.toPath(), new FileVisitOption[0]);){
            this.files = stream.filter(path -> Files.isRegularFile(path, new LinkOption[0])).filter(path -> path.getFileName().toString().endsWith(".xsd")).collect(Collectors.toList());
        }
        this.xmlReaderCreator = path -> XmlFactory.factory.createXMLStreamReader(path.toFile());
    }

    FromDirectory(Map<Path, byte[]> map, XsdInfoLoader xsdInfoLoader) {
        this.xsdInfo = xsdInfoLoader;
        this.files = new ArrayList<Path>(map.keySet());
        this.xmlReaderCreator = path -> (XMLStreamReader2)XmlFactory.factory.createXMLStreamReader((InputStream)new ByteArrayInputStream((byte[])map.get(path)));
    }

    List<Path> extractTopLevel() {
        this.graph = GraphBuilder.directed().allowsSelfLoops(false).expectedNodeCount(this.files.size()).build();
        for (Path path : this.files) {
            this.graph.addNode((Object)path);
            this.doLoad(path);
        }
        Graph graph = Graphs.transitiveClosure(this.graph);
        while (!this.graph.nodes().isEmpty()) {
            Path path;
            path = (Path)this.graph.nodes().iterator().next();
            boolean bl = this.graph.inDegree((Object)path) == 0;
            Set set = graph.successors((Object)path);
            if (!bl) {
                Set set2 = graph.predecessors((Object)path);
                bl = set.containsAll(set2);
            }
            if (bl) {
                this.topLevel.add(path);
            }
            for (Path path2 : set) {
                this.graph.removeNode((Object)path2);
            }
        }
        return this.topLevel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doLoad(Path path) {
        XMLStreamReader2 xMLStreamReader2 = null;
        try {
            xMLStreamReader2 = this.xmlReaderCreator.create(path);
            this.xsdInfo.getSchemaInfo(xMLStreamReader2);
            while (true) {
                if (xMLStreamReader2.hasNext()) {
                    Path path2;
                    String string;
                    int n = xMLStreamReader2.nextTag();
                    if (n != 1) {
                        return;
                    }
                    String string2 = xMLStreamReader2.getLocalName();
                    if ((string2.equals("import") || string2.equals("include")) && (string = xMLStreamReader2.getAttributeValue(null, "schemaLocation")) != null && !(path2 = path.getParent().resolve(string).normalize()).equals(path)) {
                        this.graph.putEdge((Object)path, (Object)path2);
                    }
                    xMLStreamReader2.skipElement();
                    continue;
                }
                break;
            }
        }
        catch (Exception exception) {
            System.err.println("Warning in processing xsd includes: " + exception.getMessage());
        }
        finally {
            try {
                if (xMLStreamReader2 != null) {
                    xMLStreamReader2.closeCompletely();
                }
            }
            catch (XMLStreamException xMLStreamException) {}
        }
    }

    @FunctionalInterface
    private static interface ReaderCreator {
        public XMLStreamReader2 create(Path var1) throws XMLStreamException;
    }
}

