/*
 * Decompiled with CFR 0.152.
 */
package com.xsdexplorer;

import com.xsdexplorer.DummyRootNode;
import com.xsdexplorer.NodeLabel;
import com.xsdexplorer.TreeNodeControl;
import com.xsdexplorer.XsdTreeNode;
import com.xsdexplorer.uihelpers.Utils;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;
import javafx.scene.input.KeyCode;
import javafx.scene.layout.Pane;
import org.apache.xerces.xs.XSElementDeclaration;
import org.apache.xerces.xs.XSModel;
import org.apache.xerces.xs.XSObject;

public class XsdTreeView
extends Pane {
    public static final double VSPACE = 18.0;
    private static final double TYPE_H_ADD = 18.0;
    private boolean metricsDirty = true;
    private XSModel model;
    private TreeNodeControl root;
    private XsdTreeNode rootNode;
    private Options options = new Options();
    private int nodeCount = 0;
    private ContextMenu contextMenu = new ContextMenu();
    private Consumer<Object> onNodeFocused;
    private Consumer<TreeNodeControl> onNodeExpanded;
    private LinkedList<XSObject> navQueue = new LinkedList();
    private NodeRec rootRec = null;

    public XsdTreeView() {
        this.options.showAnnotations.addListener((observableValue, bl, bl2) -> this.reset());
        this.options.showTypes.addListener((observableValue, bl, bl2) -> this.reset());
        this.options.showAttributes.addListener((observableValue, bl, bl2) -> this.reset());
        MenuItem menuItem = new MenuItem("Open with external editor");
        menuItem.setOnAction(actionEvent -> {
            Node node;
            MenuItem menuItem = (MenuItem)actionEvent.getTarget();
            ContextMenu contextMenu = menuItem.getParentPopup();
            if (contextMenu != null && (node = contextMenu.getOwnerNode()) instanceof NodeLabel) {
                NodeLabel nodeLabel = (NodeLabel)node;
                nodeLabel.getXsdTreeNode().onOpenExternalEditor();
            }
        });
        MenuItem menuItem2 = new MenuItem("Copy XPath");
        menuItem2.setOnAction(actionEvent -> {
            Node node;
            MenuItem menuItem = (MenuItem)actionEvent.getTarget();
            ContextMenu contextMenu = menuItem.getParentPopup();
            if (contextMenu != null && (node = contextMenu.getOwnerNode()) instanceof NodeLabel) {
                NodeLabel nodeLabel = (NodeLabel)node;
                String string = nodeLabel.getXsdTreeNode().getXpath();
                Utils.clipboardCopy(string);
            }
        });
        this.contextMenu.getItems().addAll((Object[])new MenuItem[]{menuItem, menuItem2});
        Platform.runLater(() -> {
            Parent parent = this.getParent();
            while (parent.getParent() != null) {
                parent = parent.getParent();
            }
            parent.setOnKeyPressed(keyEvent -> {
                if (keyEvent.getCode() == KeyCode.BACK_SPACE) {
                    keyEvent.consume();
                    if (!this.navQueue.isEmpty()) {
                        XSObject xSObject = this.navQueue.getLast();
                        this.setRootTerm(xSObject, this.model);
                    }
                }
            });
        });
    }

    public double getElementNodeHeight() {
        return this.rootNode.getLabelHeight();
    }

    public void setRootTerm(XSObject xSObject, XSModel xSModel) {
        if (this.model != xSModel) {
            this.navQueue.clear();
            this.model = xSModel;
        } else if (this.rootNode != null && xSObject != null) {
            if (!this.navQueue.isEmpty() && xSObject == this.navQueue.getLast()) {
                this.navQueue.removeLast();
            } else if (xSObject != this.rootNode.getTerm()) {
                if (this.navQueue.size() > 30) {
                    this.navQueue.removeFirst();
                }
                this.navQueue.add(this.rootNode.getTerm());
            }
        }
        this.getChildren().clear();
        this.nodeCount = 0;
        if (xSObject != null) {
            this.rootNode = new XsdTreeNode(xSObject, this);
            this.root = !this.rootNode.getSubstGroup().isEmpty() ? new DummyRootNode(this.rootNode) : this.rootNode;
            this.rootNode.getLabel().requestFocus();
        } else {
            this.rootNode = null;
            this.root = null;
        }
    }

    public XSElementDeclaration getRootElementDecl() {
        if (this.rootNode == null || !this.rootNode.isElement()) {
            return null;
        }
        return this.rootNode.element();
    }

    private TreeNodeControl getRoot() {
        return this.root;
    }

    public int getNodeCount() {
        return this.nodeCount;
    }

    public void addNode(TreeNodeControl treeNodeControl) {
        this.getChildren().add((Object)treeNodeControl.control());
        ++this.nodeCount;
    }

    public void requestLayout() {
        this.metricsDirty = true;
        super.requestLayout();
    }

    private void reset() {
        if (this.root != null) {
            this.rootNode.reset();
            this.getChildren().clear();
            this.nodeCount = 0;
            this.addNode(this.rootNode);
        }
    }

    protected void layoutChildren() {
        TreeNodeControl treeNodeControl = this.getRoot();
        if (treeNodeControl != null) {
            this.autoSizeNodes(treeNodeControl);
            this.layoutEdges(treeNodeControl);
        }
    }

    private void autoSizeNodes(TreeNodeControl treeNodeControl) {
        if (treeNodeControl.isVisible()) {
            treeNodeControl.autosize();
            Pane pane = treeNodeControl.getTypeRectange();
            if (pane != null && treeNodeControl.isOpen()) {
                pane.autosize();
            }
            for (TreeNodeControl treeNodeControl2 : treeNodeControl.getChildrenForLayout()) {
                this.autoSizeNodes(treeNodeControl2);
            }
        }
    }

    protected double computeMinHeight(double d) {
        return this.computePrefHeight(d);
    }

    protected double computePrefHeight(double d) {
        if (this.root == null) {
            return super.computePrefHeight(d);
        }
        return this.setupNodeHeightRecMap().totalHeight;
    }

    protected double computeMaxHeight(double d) {
        return super.computeMaxHeight(d);
    }

    protected double computePrefWidth(double d) {
        if (this.root == null) {
            return super.computePrefWidth(d);
        }
        return this.setupNodeHeightRecMap().totalWidth;
    }

    private NodeRec setupNodeHeightRecMap() {
        if (this.metricsDirty) {
            this.rootRec = this.setupNodes(this.getRoot(), this.root == this.rootNode ? 0.0 : -15.0, 0.0);
            this.metricsDirty = false;
        }
        return this.rootRec;
    }

    private NodeRec setupNodes(TreeNodeControl treeNodeControl, double d, double d2) {
        NodeRec nodeRec;
        treeNodeControl.control().setTranslateX(d);
        if (!treeNodeControl.isOpen()) {
            treeNodeControl.control().setTranslateY(d2);
            NodeRec nodeRec2 = new NodeRec(0.0, d + treeNodeControl.prefWidth(), treeNodeControl.prefHeight() + 18.0);
            return nodeRec2;
        }
        d += treeNodeControl.prefWidth() + 15.0;
        double d3 = 0.0;
        TreeNodeControl treeNodeControl3 = null;
        double d4 = 0.0;
        Pane pane = treeNodeControl.getTypeRectange();
        if (pane != null) {
            pane.setTranslateY(d2);
            pane.setTranslateX(d);
            d += 9.0;
            int n = ((XsdTreeNode.TypeRectangle)pane).childrenInType;
            treeNodeControl3 = treeNodeControl.childNodes.get(n);
            d3 = 40.0;
            d4 = 20.0;
        }
        if (!treeNodeControl.hasSingleChild()) {
            d += 15.0;
        }
        double d5 = 0.0;
        NodeRec nodeRec3 = null;
        NodeRec nodeRec4 = null;
        double d6 = d;
        List<TreeNodeControl> list = treeNodeControl.getChildrenForLayout();
        Function<TreeNodeControl, Double> function = treeNodeControl2 -> treeNodeControl.childNodes.indexOf(treeNodeControl2) == -1 ? 7.0 : 0.0;
        TreeNodeControl treeNodeControl4 = treeNodeControl.childNodes.get(treeNodeControl.childNodes.size() - 1);
        for (TreeNodeControl treeNodeControl5 : list) {
            nodeRec = this.setupNodes(treeNodeControl5, d + function.apply(treeNodeControl5), d3 + d2);
            if (nodeRec3 == null) {
                nodeRec3 = nodeRec;
            }
            if (treeNodeControl5 == treeNodeControl4) {
                d5 = d3;
                nodeRec4 = nodeRec;
            }
            if (nodeRec.totalWidth > d6) {
                d6 = nodeRec.totalWidth;
            }
            d3 += nodeRec.totalHeight;
            if (treeNodeControl5 != treeNodeControl3) continue;
            pane.setPrefHeight(d3);
            d3 += 10.0;
            pane.setPrefWidth(-1.0);
            double d7 = pane.prefWidth(-1.0) + 5.0;
            d6 = Double.max(d + d7, d6 + 9.0);
            pane.setPrefWidth(d6 - pane.getTranslateX());
        }
        treeNodeControl.control().setTranslateY(d2 + (d4 += (d5 + nodeRec3.childCut + nodeRec4.childCut) / 2.0));
        double d8 = Double.max(d3, d4 + treeNodeControl.prefHeight() + 18.0);
        nodeRec = new NodeRec(d4, d6, d8);
        return nodeRec;
    }

    private void layoutEdges(TreeNodeControl treeNodeControl) {
        treeNodeControl.layoutSubstEdges(this.getElementNodeHeight());
        if (treeNodeControl.isOpen()) {
            treeNodeControl.layoutEdges(this.getElementNodeHeight());
            for (TreeNodeControl treeNodeControl2 : treeNodeControl.getChildrenForLayout()) {
                this.layoutEdges(treeNodeControl2);
            }
        }
    }

    public Options getOptions() {
        return this.options;
    }

    public ContextMenu getContextMenu(XsdTreeNode xsdTreeNode) {
        ((MenuItem)this.contextMenu.getItems().get(1)).setDisable(!xsdTreeNode.isElement());
        return this.contextMenu;
    }

    public XSModel getModel() {
        return this.model;
    }

    public void onNodeFocused(Object object) {
        if (this.onNodeFocused != null) {
            this.onNodeFocused.accept(object);
        }
    }

    public void setOnNodeFocusConsumer(Consumer<Object> consumer) {
        this.onNodeFocused = consumer;
    }

    public void onNodeExpanded(TreeNodeControl treeNodeControl) {
        if (this.onNodeExpanded != null) {
            this.onNodeExpanded.accept(treeNodeControl);
        }
    }

    public void setOnNodeExpandedConsumer(Consumer<TreeNodeControl> consumer) {
        this.onNodeExpanded = consumer;
    }

    public static class Options {
        BooleanProperty showAttributes = new SimpleBooleanProperty(true);
        BooleanProperty showAnnotations = new SimpleBooleanProperty(true);
        BooleanProperty showTypes = new SimpleBooleanProperty(true);
    }

    private static class NodeRec {
        double childCut;
        double totalHeight;
        double totalWidth;

        NodeRec(double d, double d2, double d3) {
            this.childCut = d;
            this.totalWidth = d2;
            this.totalHeight = d3;
        }
    }
}

