/*
 * Decompiled with CFR 0.152.
 */
package com.xsdexplorer;

import com.xsdexplorer.GlobalsToolbar;
import com.xsdexplorer.LogView;
import com.xsdexplorer.RecentItems;
import com.xsdexplorer.XsdTreeView;
import com.xsdexplorer.loader.EntityResolverImpl;
import com.xsdexplorer.loader.RootSelector;
import com.xsdexplorer.loader.SchemaLoader;
import com.xsdexplorer.loader.SchemaLoaderTask;
import com.xsdexplorer.settings.AboutDialog;
import com.xsdexplorer.settings.SettingsDialog;
import com.xsdexplorer.tools.gensample.GenSampleRunner;
import com.xsdexplorer.uihelpers.ZoomableScrollPane;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.prefs.Preferences;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javafx.application.Application;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.CheckMenuItem;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuBar;
import javafx.scene.control.MenuItem;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.image.Image;
import javafx.scene.input.DragEvent;
import javafx.scene.input.Dragboard;
import javafx.scene.input.KeyCombination;
import javafx.scene.input.TransferMode;
import javafx.scene.layout.BorderPane;
import javafx.stage.DirectoryChooser;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import org.apache.commons.lang3.StringUtils;
import org.apache.xerces.impl.Constants;
import org.apache.xerces.impl.xs.XMLSchemaValidator;
import org.apache.xerces.parsers.XML11Configuration;
import org.apache.xerces.util.SymbolTable;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.grammars.XMLGrammarPool;
import org.apache.xerces.xni.parser.XMLConfigurationException;
import org.apache.xerces.xni.parser.XMLErrorHandler;
import org.apache.xerces.xni.parser.XMLInputSource;
import org.apache.xerces.xni.parser.XMLParseException;
import org.apache.xerces.xs.XSElementDeclaration;
import org.apache.xerces.xs.XSModel;
import org.apache.xerces.xs.XSObject;

public class XsdExplorer
extends Application {
    private XSModel model;
    private BorderPane root;
    private XsdTreeView xsdTreeView;
    private Preferences prefs = Preferences.userNodeForPackage(XsdExplorer.class);
    private RecentItems recentItems = new RecentItems(10, this.prefs);
    private File lastFile;
    private XMLGrammarPool pool;
    private SymbolTable symbolTable;
    private boolean isXsd11;
    private LogView logView;
    private SimpleBooleanProperty schemaLoaded = new SimpleBooleanProperty(false);
    private static XsdExplorer app;
    private static final Pattern acceptFilesPattern;

    public LogView getLogView() {
        return this.logView;
    }

    public Preferences getPrefs() {
        return this.prefs;
    }

    public void start(Stage stage) {
        app = this;
        stage.getIcons().add((Object)new Image(XsdExplorer.class.getResourceAsStream("/icon.png")));
        this.xsdTreeView = new XsdTreeView();
        ZoomableScrollPane zoomableScrollPane = new ZoomableScrollPane((Node)this.xsdTreeView);
        zoomableScrollPane.setPadding(new Insets(18.0, 16.0, 0.0, 16.0));
        zoomableScrollPane.fitToHeightProperty().set(true);
        zoomableScrollPane.pannableProperty().set(true);
        zoomableScrollPane.hbarPolicyProperty().setValue((Object)ScrollPane.ScrollBarPolicy.AS_NEEDED);
        zoomableScrollPane.vbarPolicyProperty().setValue((Object)ScrollPane.ScrollBarPolicy.AS_NEEDED);
        zoomableScrollPane.setOnDragOver(dragEvent -> {
            List list;
            if (dragEvent.getGestureSource() != zoomableScrollPane && dragEvent.getDragboard().hasFiles() && XsdExplorer.acceptFiles(list = dragEvent.getDragboard().getFiles())) {
                dragEvent.acceptTransferModes(TransferMode.COPY_OR_MOVE);
            }
            dragEvent.consume();
        });
        zoomableScrollPane.setOnDragDropped(this::onDragDropped);
        this.root = new BorderPane();
        this.root.setTop((Node)this.createMenuBar(this.xsdTreeView.getOptions(), stage));
        this.root.setCenter((Node)zoomableScrollPane);
        this.root.setBottom(this.createLogView());
        Scene scene = new Scene((Parent)this.root, 1200.0, 800.0);
        scene.getStylesheets().add((Object)((Object)((Object)this)).getClass().getResource("/styles.css").toExternalForm());
        stage.setTitle("Xsd Explorer");
        stage.setScene(scene);
        stage.show();
    }

    private static boolean acceptFiles(List<File> list) {
        return list.stream().allMatch(file -> file.isDirectory() || acceptFilesPattern.matcher(file.getName()).find());
    }

    private Node createLogView() {
        this.logView = new LogView();
        return this.logView.createLogView();
    }

    private MenuBar createMenuBar(XsdTreeView.Options options, Stage stage) {
        Menu menu = new Menu("File");
        Menu menu2 = new Menu("View");
        Menu menu3 = new Menu("Tools");
        Menu menu4 = new Menu("Help");
        MenuItem menuItem = new MenuItem("_Open...");
        menuItem.setOnAction(actionEvent -> this.onOpenFile());
        menuItem.setAccelerator(KeyCombination.keyCombination((String)"SHORTCUT+O"));
        MenuItem menuItem2 = new MenuItem("_Open Directory...");
        menuItem2.setOnAction(actionEvent -> this.onOpenDir());
        MenuItem menuItem3 = new MenuItem("_Exit");
        menuItem3.setOnAction(actionEvent -> stage.close());
        Menu menu5 = new Menu("Show in diagram");
        CheckMenuItem checkMenuItem = new CheckMenuItem("attributes");
        checkMenuItem.setSelected(options.showAttributes.get());
        checkMenuItem.setOnAction(actionEvent -> options.showAttributes.set(checkMenuItem.isSelected()));
        CheckMenuItem checkMenuItem2 = new CheckMenuItem("annotations");
        checkMenuItem2.setSelected(options.showAnnotations.get());
        checkMenuItem2.setOnAction(actionEvent -> options.showAnnotations.set(checkMenuItem2.isSelected()));
        CheckMenuItem checkMenuItem3 = new CheckMenuItem("types");
        checkMenuItem3.setSelected(options.showTypes.get());
        checkMenuItem3.setOnAction(actionEvent -> options.showTypes.set(checkMenuItem3.isSelected()));
        menu5.getItems().addAll((Object[])new MenuItem[]{checkMenuItem, checkMenuItem2, checkMenuItem3});
        menu.getItems().addAll((Object[])new MenuItem[]{menuItem, menuItem2, new SeparatorMenuItem(), menuItem3});
        this.recentItems.addObserver(recentItems -> this.addMRecentFiles(menu, 3));
        this.addMRecentFiles(menu, 3);
        menu2.getItems().addAll((Object[])new MenuItem[]{menu5});
        MenuItem menuItem4 = new MenuItem("Settings");
        menuItem4.setOnAction(actionEvent -> new SettingsDialog().showSettingsDialog(stage));
        MenuItem menuItem5 = new MenuItem("Generate Sample XML");
        menuItem5.setOnAction(actionEvent -> new GenSampleRunner().run(this.model, this.xsdTreeView.getRootElementDecl()));
        menuItem5.disableProperty().bind((ObservableValue)this.schemaLoaded.not());
        menu3.getItems().addAll((Object[])new MenuItem[]{menuItem5, new SeparatorMenuItem(), menuItem4});
        MenuItem menuItem6 = new MenuItem("_Help");
        menuItem6.setOnAction(actionEvent -> this.onOpenHelpFile());
        menuItem6.setAccelerator(KeyCombination.keyCombination((String)"F1"));
        MenuItem menuItem7 = new MenuItem("About ...");
        menuItem7.setOnAction(actionEvent -> new AboutDialog().showAboutDialog());
        menu4.getItems().addAll((Object[])new MenuItem[]{menuItem6, menuItem7});
        MenuBar menuBar = new MenuBar(new Menu[]{menu, menu2, menu3, menu4});
        return menuBar;
    }

    private void onOpenHelpFile() {
        String string = "https://www.xsdexplorer.com/";
        this.getHostServices().showDocument(string);
    }

    private void addMRecentFiles(Menu menu, int n) {
        menu.getItems().subList(n, menu.getItems().size()).clear();
        List<String> list = this.recentItems.getItems();
        if (list.isEmpty()) {
            return;
        }
        menu.getItems().add((Object)new SeparatorMenuItem());
        for (int i = 0; i < list.size(); ++i) {
            String string = list.get(i);
            File file = new File(string);
            if (!file.exists()) continue;
            MenuItem menuItem = new MenuItem(StringUtils.abbreviateMiddle((String)String.format("%d: %s", i + 1, string), (String)"\u2026", (int)40));
            menu.getItems().add((Object)menuItem);
            menuItem.setOnAction(actionEvent -> this.onLastFileUpdated(file));
        }
    }

    public void onDragDropped(DragEvent dragEvent) {
        Dragboard dragboard = dragEvent.getDragboard();
        boolean bl = false;
        if (dragboard.hasFiles()) {
            List<File> list;
            Map<Boolean, List<File>> map = dragboard.getFiles().stream().collect(Collectors.groupingBy(file -> file.getName().endsWith(".xml")));
            List<File> list2 = map.get(false);
            if (list2 != null && !list2.isEmpty()) {
                this.onLastFileUpdated((File[])list2.toArray(File[]::new));
            }
            if ((list = map.get(true)) != null) {
                for (File file2 : list) {
                    this.validateXml(file2);
                }
            }
            bl = true;
        }
        dragEvent.setDropCompleted(bl);
        dragEvent.consume();
    }

    private void validateXml(File file) {
        MyXML11Configuration myXML11Configuration = new MyXML11Configuration(this.symbolTable, this.pool);
        myXML11Configuration.setEntityResolver(new EntityResolverImpl());
        myXML11Configuration.setFeature("http://xml.org/sax/features/validation", true);
        myXML11Configuration.setFeature("http://apache.org/xml/features/validation/schema-full-checking", true);
        myXML11Configuration.setFeature("http://apache.org/xml/features/validation/schema", true);
        MyErrorHandler myErrorHandler = new MyErrorHandler();
        myXML11Configuration.setErrorHandler(myErrorHandler);
        System.out.println("Validating " + file);
        try {
            myXML11Configuration.parse(new XMLInputSource(null, file.getAbsolutePath(), null));
            if (!myErrorHandler.hasErrors) {
                this.logView.addMessage(LogView.Kind.SUCCESS, file + ": validation successfull!");
            }
        }
        catch (XNIException xNIException) {
            if (!myErrorHandler.fatalError) {
                this.logView.addMessage(LogView.Kind.ERROR, xNIException.getMessage());
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void onOpenFile() {
        FileChooser fileChooser = new FileChooser();
        if (this.lastFile != null) {
            fileChooser.setInitialDirectory(this.lastFile.getParentFile());
        }
        fileChooser.getExtensionFilters().addAll((Object[])new FileChooser.ExtensionFilter[]{new FileChooser.ExtensionFilter("XSD Files", new String[]{"*.xsd"}), new FileChooser.ExtensionFilter("Zip Files", new String[]{"*.zip"})});
        File file = fileChooser.showOpenDialog(this.root.getScene().getWindow());
        if (file != null) {
            this.onLastFileUpdated(file);
        }
    }

    private void onOpenDir() {
        File file;
        DirectoryChooser directoryChooser = new DirectoryChooser();
        if (this.lastFile != null) {
            directoryChooser.setInitialDirectory(this.lastFile.getParentFile());
        }
        if ((file = directoryChooser.showDialog(this.root.getScene().getWindow())) != null) {
            this.onLastFileUpdated(file);
        }
    }

    private void onLastFileUpdated(File ... fileArray) {
        this.logView.clear();
        this.root.getScene().setCursor(Cursor.WAIT);
        SchemaLoaderTask schemaLoaderTask = new SchemaLoaderTask(fileArray);
        schemaLoaderTask.messageProperty().addListener((observableValue, string, string2) -> {
            int n = string2.indexOf(93);
            String string3 = string2.substring(1, n);
            string2 = string2.substring(n + 1);
            this.logView.addMessage(LogView.Kind.valueOf(string3), (String)string2);
        });
        schemaLoaderTask.setOnSucceeded(workerStateEvent -> {
            for (int i = 0; i < fileArray.length; ++i) {
                this.recentItems.push(fileArray[i].getAbsolutePath());
                this.lastFile = fileArray[i];
            }
            SchemaLoader schemaLoader = (SchemaLoader)schemaLoaderTask.getValue();
            this.model = schemaLoader.getXSModel();
            this.pool = schemaLoader.getPool();
            this.symbolTable = schemaLoader.getSymbolTable();
            this.isXsd11 = schemaLoader.isXsd11();
            RootSelector rootSelector = new RootSelector(this.model);
            XSElementDeclaration xSElementDeclaration = rootSelector.selectRoot();
            GlobalsToolbar globalsToolbar = new GlobalsToolbar(this.model, xSObject -> this.xsdTreeView.setRootTerm((XSObject)xSObject, this.model));
            this.root.setRight((Node)globalsToolbar.createToolBar());
            this.xsdTreeView.setOnNodeFocusConsumer(object -> globalsToolbar.populatePropsFor(object));
            this.xsdTreeView.setRootTerm((XSObject)xSElementDeclaration, this.model);
            this.schemaLoaded.set(true);
            this.root.getScene().setCursor(Cursor.DEFAULT);
        });
        schemaLoaderTask.setOnFailed(workerStateEvent -> {
            this.root.getScene().setCursor(Cursor.DEFAULT);
            Throwable throwable = schemaLoaderTask.getException();
            String string = XsdExplorer.fixMessage(throwable);
            this.logView.addMessage(LogView.Kind.ERROR, string);
            Alert alert = new Alert(Alert.AlertType.ERROR);
            alert.setTitle("Invalid xsd file");
            alert.setHeaderText("Error loading file");
            alert.setContentText(string);
            alert.showAndWait();
            this.schemaLoaded.set(false);
        });
        Thread thread = new Thread((Runnable)((Object)schemaLoaderTask));
        thread.setDaemon(true);
        thread.start();
    }

    private static String fixMessage(Throwable throwable) {
        String string = throwable.getMessage();
        if (string == null) {
            throwable.printStackTrace();
            return throwable.toString();
        }
        int n = string.indexOf("[Fatal Error]", 1);
        return n != -1 ? string.substring(n) : string;
    }

    public static XsdExplorer getApp() {
        return app;
    }

    public static void addLogViewMessage(LogView.Kind kind, String string) {
        if (app != null) {
            app.getLogView().addMessage(kind, string);
        }
    }

    public static void main(String[] stringArray) {
        XsdExplorer.launch((String[])new String[0]);
    }

    static {
        acceptFilesPattern = Pattern.compile("\\.(xsd|xml|zip)$");
    }

    private class MyXML11Configuration
    extends XML11Configuration {
        public MyXML11Configuration(SymbolTable symbolTable, XMLGrammarPool xMLGrammarPool) {
            super(symbolTable, xMLGrammarPool, null);
        }

        public void setProperty(String string, Object object) throws XMLConfigurationException {
            if (XsdExplorer.this.isXsd11 && string.equals("http://apache.org/xml/properties/internal/validator/schema")) {
                XMLSchemaValidator xMLSchemaValidator = (XMLSchemaValidator)object;
                xMLSchemaValidator.setProperty("http://apache.org/xml/properties/validation/schema/version", (Object)Constants.W3C_XML_SCHEMA11_NS_URI);
            }
            super.setProperty(string, object);
        }
    }

    private class MyErrorHandler
    implements XMLErrorHandler {
        boolean hasErrors;
        boolean fatalError;

        private MyErrorHandler() {
        }

        public void warning(String string, String string2, XMLParseException xMLParseException) throws XNIException {
            System.out.println("Warning: ");
            this.printInfo(xMLParseException);
        }

        public void error(String string, String string2, XMLParseException xMLParseException) throws XNIException {
            System.err.println("Error: ");
            this.printInfo(xMLParseException);
        }

        public void fatalError(String string, String string2, XMLParseException xMLParseException) throws XNIException {
            System.err.println("Fatal error: ");
            this.fatalError = true;
            this.printInfo(xMLParseException);
        }

        private void printInfo(XMLParseException xMLParseException) {
            this.hasErrors = true;
            System.err.println("   Public ID: " + xMLParseException.getPublicId());
            System.err.println("   System ID: " + xMLParseException.getExpandedSystemId());
            System.err.println("   Line number: " + xMLParseException.getLineNumber());
            System.err.println("   Column number: " + xMLParseException.getColumnNumber());
            System.err.println("   Message: " + xMLParseException.getMessage());
            String string = xMLParseException.getExpandedSystemId();
            if (string.startsWith("file://")) {
                string = new File(string.substring(7)).getAbsolutePath();
            }
            XsdExplorer.this.logView.addMessage(LogView.Kind.ERROR, string + ": line " + xMLParseException.getLineNumber() + ", column " + xMLParseException.getColumnNumber() + ": " + xMLParseException.getMessage());
        }
    }
}

