/*
 * Decompiled with CFR 0.152.
 */
package com.xsdexplorer;

import com.xsdexplorer.XsdTreeNode;
import java.util.List;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.geometry.Bounds;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.shape.PathElement;
import javafx.scene.shape.VLineTo;

public class SubstEdges {
    public static final double SUBST_OFFSET = 7.0;
    private Path vLine;
    private MoveTo[] childHLines;

    private SubstEdges(XsdTreeNode xsdTreeNode) {
        ObservableList observableList = xsdTreeNode.getParentLayout().getChildren();
        observableList.add((Object)this.createPath());
        List<XsdTreeNode> list = xsdTreeNode.getSubstGroup();
        int n = list.size();
        this.childHLines = new MoveTo[n];
        for (int i = 0; i < n; ++i) {
            MoveTo moveTo = this.childHLines[i] = new MoveTo(0.0, 0.0);
            LineTo lineTo = new LineTo(7.0, 7.0);
            lineTo.setAbsolute(false);
            this.vLine.getElements().addAll((Object[])new PathElement[]{moveTo, lineTo});
        }
        this.vLine.visibleProperty().bind((ObservableValue)xsdTreeNode.control().visibleProperty());
    }

    public static SubstEdges createIfNeeded(XsdTreeNode xsdTreeNode) {
        if (xsdTreeNode.getSubstGroup().isEmpty()) {
            return null;
        }
        return new SubstEdges(xsdTreeNode);
    }

    private Path createPath() {
        MoveTo moveTo = new MoveTo(0.0, 0.0);
        VLineTo vLineTo = new VLineTo(100.0);
        MoveTo moveTo2 = new MoveTo(0.0, 0.0);
        LineTo lineTo = new LineTo(-4.0, 4.0);
        MoveTo moveTo3 = new MoveTo(0.0, 0.0);
        LineTo lineTo2 = new LineTo(4.0, 4.0);
        this.vLine = new Path(new PathElement[]{moveTo, vLineTo, moveTo2, lineTo, moveTo3, lineTo2});
        return this.vLine;
    }

    private void updatePathHeight(double d) {
        VLineTo vLineTo = (VLineTo)this.vLine.getElements().get(1);
        vLineTo.setY(d);
    }

    public void layoutSubstElements(XsdTreeNode xsdTreeNode, double d) {
        List<XsdTreeNode> list = xsdTreeNode.getSubstGroup();
        int n = list.size();
        if (n == 0) {
            return;
        }
        Bounds bounds = xsdTreeNode.getBoundsInParent();
        this.vLine.relocate(bounds.getMinX() - 5.0, bounds.getMaxY() + 1.0);
        double d2 = bounds.getMaxY() + 7.0 - d / 2.0;
        for (int i = 0; i < this.childHLines.length; ++i) {
            XsdTreeNode xsdTreeNode2 = list.get(i);
            Bounds bounds2 = xsdTreeNode2.getBoundsInParent();
            this.childHLines[i].setY(bounds2.getMinY() - d2);
        }
        Bounds bounds3 = list.get(n - 1).getBoundsInParent();
        this.updatePathHeight(bounds3.getMinY() - d2);
    }
}

