/*
 * Decompiled with CFR 0.152.
 */
package com.xsdexplorer;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.prefs.Preferences;

public class RecentItems {
    public static final String RECENT_ITEM_STRING = "recent.item.";
    private int m_maxItems;
    private Preferences m_prefNode;
    private List<RecentItemsObserver> m_observers = new ArrayList<RecentItemsObserver>();
    private ArrayDeque<String> m_items = new ArrayDeque();

    public RecentItems(int n, Preferences preferences) {
        this.m_maxItems = n;
        this.m_prefNode = preferences;
        this.loadFromPreferences();
    }

    public void push(String string) {
        this.m_items.remove(string);
        this.m_items.addFirst(string);
        if (this.m_items.size() > this.m_maxItems) {
            this.m_items.removeLast();
        }
        this.update();
    }

    public void remove(Object object) {
        this.m_items.remove(object);
        this.update();
    }

    public List<String> getItems() {
        return this.m_items.stream().toList();
    }

    public int size() {
        return this.m_items.size();
    }

    public void addObserver(RecentItemsObserver recentItemsObserver) {
        this.m_observers.add(recentItemsObserver);
    }

    public void removeObserver(RecentItemsObserver recentItemsObserver) {
        this.m_observers.remove(recentItemsObserver);
    }

    private void update() {
        for (RecentItemsObserver recentItemsObserver : this.m_observers) {
            recentItemsObserver.onRecentItemChange(this);
        }
        this.storeToPreferences();
    }

    private void loadFromPreferences() {
        String string;
        for (int i = 0; i < this.m_maxItems && !(string = this.m_prefNode.get(RECENT_ITEM_STRING + i, "")).equals(""); ++i) {
            this.m_items.add(string);
        }
    }

    private void storeToPreferences() {
        int n = 0;
        for (String string : this.m_items) {
            this.m_prefNode.put(RECENT_ITEM_STRING + n, string);
            ++n;
        }
        while (n < this.m_maxItems) {
            this.m_prefNode.remove(RECENT_ITEM_STRING + n);
            ++n;
        }
    }

    public static interface RecentItemsObserver {
        public void onRecentItemChange(RecentItems var1);
    }
}

