/*
 * Decompiled with CFR 0.152.
 */
package com.xsdexplorer;

import com.xsdexplorer.XsdTreeNode;
import java.util.List;
import java.util.stream.Collectors;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Line;
import javafx.scene.shape.Polyline;
import javafx.scene.shape.Rectangle;
import javafx.scene.shape.SVGPath;
import javafx.scene.shape.Shape;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import javafx.scene.transform.Rotate;
import javafx.util.Duration;
import org.apache.commons.lang3.StringUtils;
import org.apache.xerces.xs.StringList;
import org.apache.xerces.xs.XSModelGroup;
import org.apache.xerces.xs.XSObject;
import org.apache.xerces.xs.XSWildcard;

public class NodeLabel
extends Pane {
    private static String SVG_MODEL_GROUP = "M 10 20 v -10 l 5 -5 h 25 L 45 10 V 20 L 40 25 H 15 Z";
    private static String SVG_TYPE_DEF = "m 15 25 c -4 -6 -4 -14 0 -20 H 75 V 25 H 15 Z";
    private static String SVG_ELEMENT = "M 0 0 V 10 H 20 V 0 Z";
    private static String SVG_SEQ_INSIDE = "M 14 15 H 41 M 20.948 14.103 h 1.703 v 1.703 h -1.703 Z M 25.948 14.103 h 1.703 v 1.703 h -1.703 Z M 30.93 14.103 h 1.703 v 1.703 h -1.703 Z";
    private static String SVG_CHOICE_INSIDE = "M 26.177 9.877 h 1.703 v 1.703 h -1.703 Z M 26.177 14.151 h 1.703 v 1.703 h -1.703 Z M 26.177 18.335 h 1.703 v 1.703 h -1.703 Z M 41.972 15.052 H 30.645 Z M 35.917 9.998 H 30.645 Z V 20.135 Z M 35.91 20.034 H 30.645 Z M 19.268 14.963 H 13.289 Z L 23.05 9.933 Z";
    private static String SVG_ALL_INSIDE = "M 26.177 9.877 h 1.703 v 1.703 h -1.703 Z M 26.177 14.151 h 1.703 v 1.703 h -1.703 Z M 26.177 18.335 h 1.703 v 1.703 h -1.703 Z M 41.972 15.052 H 30.645 Z M 35.917 9.998 H 30.645 Z V 20.135 Z M 35.91 20.034 H 30.645 Z M 17.979 15.026 H 13.256 Z h 5.468 Z V 10.101 Z V 19.992 Z M 17.968 10.033 h 5.468 Z M 17.987 20.011 h 5.468 Z";
    private static final double PLUS_SIZE = 10.0;
    private static final double HEIGHT_ADD = 6.0;
    private double svgAspectX;
    private double svgAspectY;
    private Text text;
    private Group plusMinusControl;
    private boolean addGlobalRefArrow;
    private boolean isSimpleContent;
    private XsdTreeNode xsdTreeNode;
    private static Font font = null;
    private static SvgSize svgSize;

    private NodeLabel(XsdTreeNode xsdTreeNode) {
        this.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        this.setMaxSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        this.setFocusTraversable(true);
        this.getStyleClass().add((Object)"nodeLabel");
        this.xsdTreeNode = xsdTreeNode;
    }

    private NodeLabel(String string, XsdTreeNode xsdTreeNode) {
        this(xsdTreeNode);
        String string2 = StringUtils.abbreviate((String)string, (int)30);
        this.text = new Text(StringUtils.rightPad((String)string2, (int)5, (char)' '));
        if (string.length() > 30) {
            Tooltip tooltip = new Tooltip(string);
            tooltip.setShowDelay(Duration.millis((double)200.0));
            Tooltip.install((Node)this, (Tooltip)tooltip);
        }
        this.setTextFont();
    }

    private void setTextFont() {
        if (font == null) {
            this.text.setStyle("-fx-font-weight: bold;");
            new Scene((Parent)new Group(new Node[]{this.text}));
            this.text.applyCss();
            font = this.text.getFont();
            double d = this.text.prefHeight(-1.0) + 6.0;
            double d2 = d * 1.75;
            svgSize = new SvgSize(d2, d);
        } else {
            this.text.setFont(font);
        }
    }

    static Font getFont() {
        return font;
    }

    public static NodeLabel createNodeLabel(XsdTreeNode xsdTreeNode) {
        boolean bl = xsdTreeNode.getMaxOccurs() > 1 || xsdTreeNode.getMaxOccurs() == -1;
        int n = xsdTreeNode.getMinOccurs();
        boolean bl2 = xsdTreeNode.hasXsdChildren();
        XSObject xSObject = xsdTreeNode.getTerm();
        switch (xSObject.getType()) {
            case 2: {
                NodeLabel nodeLabel = new NodeLabel(xSObject.getName(), xsdTreeNode);
                nodeLabel.setElementOptions(xsdTreeNode.isGlobalRef(), xsdTreeNode.isSimpleContent());
                nodeLabel.initNode(SVG_ELEMENT, n, bl, bl2);
                return nodeLabel;
            }
            case 7: {
                NodeLabel nodeLabel = new NodeLabel(xsdTreeNode);
                nodeLabel.initNode(SVG_MODEL_GROUP, n, bl, bl2);
                nodeLabel.addGroupNodeInnerSvg(((XSModelGroup)xSObject).getCompositor());
                return nodeLabel;
            }
            case 9: {
                Object object;
                XSWildcard xSWildcard = (XSWildcard)xSObject;
                String string2 = "";
                switch (xSWildcard.getConstraintType()) {
                    case 1: {
                        string2 = "##any";
                        break;
                    }
                    case 2: {
                        string2 = "##other";
                        break;
                    }
                    case 3: {
                        object = NodeLabel.castStringList(xSWildcard.getNsConstraintList());
                        string2 = object.stream().map(string -> string == null ? "##local" : string).collect(Collectors.joining(" "));
                    }
                }
                object = "any ";
                object = !string2.isEmpty() ? (String)object + StringUtils.abbreviate((String)string2, (int)25) : (String)object + "     ";
                NodeLabel nodeLabel = new NodeLabel((String)object, xsdTreeNode);
                nodeLabel.initNode(SVG_MODEL_GROUP, n, bl, bl2);
                return nodeLabel;
            }
            case 3: {
                NodeLabel nodeLabel = new NodeLabel(xSObject.getName(), xsdTreeNode);
                nodeLabel.initNode(SVG_TYPE_DEF, n, bl, bl2);
                return nodeLabel;
            }
        }
        throw new RuntimeException("Unrecognized type");
    }

    private static List<String> castStringList(StringList stringList) {
        return stringList;
    }

    private void addGroupNodeInnerSvg(int n) {
        SVGPath sVGPath = new SVGPath();
        if (n == 1) {
            sVGPath.setContent(SVG_SEQ_INSIDE);
        } else if (n == 2) {
            sVGPath.setContent(SVG_CHOICE_INSIDE);
        } else {
            sVGPath.setContent(SVG_ALL_INSIDE);
        }
        sVGPath.setScaleX(this.svgAspectX);
        sVGPath.setScaleY(this.svgAspectY);
        sVGPath.setStroke((Paint)Color.BLACK);
        sVGPath.setFill((Paint)Color.BLACK);
        sVGPath.setStrokeWidth(1.0);
        double d = sVGPath.prefWidth(-1.0) * this.svgAspectX;
        double d2 = sVGPath.prefHeight(d) * this.svgAspectY;
        Group group = new Group(new Node[]{sVGPath});
        this.getChildren().add((Object)group);
        group.relocate((NodeLabel.svgSize.width - d) / 2.0, NodeLabel.svgSize.height / 2.0 - d2 / 2.0);
    }

    private void initNode(String string, int n, boolean bl, boolean bl2) {
        double d;
        double d2;
        double d3;
        SVGPath sVGPath = new SVGPath();
        sVGPath.setContent(string);
        if (this.text != null) {
            d3 = this.text.prefWidth(-1.0) + 20.0;
            d2 = this.text.prefHeight(-1.0) + 6.0;
            this.text.relocate(10.0, 3.0);
            d = 5.0;
        } else {
            d3 = NodeLabel.svgSize.width;
            d2 = NodeLabel.svgSize.height;
            d = 1.0;
        }
        Region region = this.addSvgMainShape(sVGPath, n, d3, d2);
        if (bl) {
            sVGPath = new SVGPath();
            sVGPath.setContent(string);
            Region region2 = this.svgInRegion(sVGPath, d3, d2);
            this.getChildren().add((Object)region2);
            region.relocate(3.0, 3.0);
            region2.relocate(0.0, 0.0);
            region2.getStyleClass().addAll((Object[])new String[]{"nodeShape", n == 0 ? "optionalShape" : "requiredShape"});
        }
        if (this.text != null) {
            this.getChildren().add((Object)this.text);
            this.addGlobalRefSignIfNeeded();
            this.showSimpleContentIfNeeded();
        }
        if (bl2) {
            this.createPlusMinus();
            this.plusMinusControl.relocate(d3 - d, (d2 - 10.0) / 2.0);
        }
    }

    private Region addSvgMainShape(SVGPath sVGPath, int n, double d, double d2) {
        Region region = this.svgInRegion(sVGPath, d, d2);
        region.getStyleClass().addAll((Object[])new String[]{"nodeShape", "shapeWithShadow", n == 0 ? "optionalShape" : "requiredShape"});
        this.getChildren().add((Object)region);
        region.relocate(0.0, 0.0);
        this.svgAspectX = d / sVGPath.prefWidth(-1.0);
        this.svgAspectY = d2 / sVGPath.prefHeight(d);
        return region;
    }

    private Region svgInRegion(SVGPath sVGPath, double d, double d2) {
        Region region = new Region();
        region.setShape((Shape)sVGPath);
        region.setMinSize(d, d2);
        region.setPrefSize(d, d2);
        return region;
    }

    public String getText() {
        return this.text.getText();
    }

    private void createPlusMinus() {
        Group group = new Group();
        group.setFocusTraversable(false);
        Rectangle rectangle = new Rectangle(10.0, 10.0);
        rectangle.setFill((Paint)Color.WHITE);
        rectangle.setStroke((Paint)Color.BLACK);
        rectangle.setStrokeWidth(1.0);
        Line line = new Line(2.0, 5.0, 8.0, 5.0);
        Line line2 = new Line(5.0, 2.0, 5.0, 8.0);
        group.getChildren().addAll((Object[])new Node[]{rectangle, line, line2});
        this.getChildren().add((Object)group);
        this.plusMinusControl = group;
    }

    private void addGlobalRefSignIfNeeded() {
        if (!this.addGlobalRefArrow) {
            return;
        }
        Polyline polyline = new Polyline();
        polyline.getPoints().addAll((Object[])new Double[]{0.0, 0.0, 6.0, 6.0, 6.0, 3.5, 3.5, 6.0, 6.0, 6.0});
        this.getChildren().add((Object)polyline);
        polyline.getTransforms().add((Object)new Rotate(-90.0, 0.0, 0.0));
        polyline.relocate(0.0, NodeLabel.svgSize.height - 2.0);
    }

    private void showSimpleContentIfNeeded() {
        if (this.isSimpleContent) {
            SVGPath sVGPath = new SVGPath();
            sVGPath.setContent("M 0 3 H 5 M 0 6 H 5 M 0 9 H 5");
            this.getChildren().add((Object)sVGPath);
            sVGPath.setFill((Paint)Color.TRANSPARENT);
            sVGPath.setStroke((Paint)Color.BLACK);
            sVGPath.relocate(0.0, 0.0);
        }
    }

    public void toggleOpenControl() {
        Node node;
        node.setVisible(!(node = (Node)this.plusMinusControl.getChildren().get(2)).isVisible());
    }

    public void resetOpenControl(boolean bl) {
        if (bl) {
            if (this.plusMinusControl != null) {
                Node node = (Node)this.plusMinusControl.getChildren().get(2);
                node.setVisible(true);
            } else {
                this.createPlusMinus();
            }
        } else if (this.plusMinusControl != null) {
            this.getChildren().remove((Object)this.plusMinusControl);
            this.plusMinusControl = null;
        }
    }

    public Node getOnClickControl() {
        return this.plusMinusControl;
    }

    public XsdTreeNode getXsdTreeNode() {
        return this.xsdTreeNode;
    }

    public void setElementOptions(boolean bl, boolean bl2) {
        this.addGlobalRefArrow = bl;
        this.isSimpleContent = bl2;
    }

    private static class SvgSize {
        final double width;
        final double height;

        SvgSize(double d, double d2) {
            this.width = d;
            this.height = d2;
        }
    }
}

