/*
 * Decompiled with CFR 0.152.
 */
package com.xsdexplorer;

import com.google.common.base.Preconditions;
import com.xsdexplorer.AttributeNode;
import com.xsdexplorer.TreeNodeControl;
import com.xsdexplorer.XsdTreeNode;
import com.xsdexplorer.XsdTreeView;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.xerces.impl.xs.SchemaGrammar;
import org.apache.xerces.impl.xs.XSComplexTypeDecl;
import org.apache.xerces.xs.XSAttributeUse;
import org.apache.xerces.xs.XSModelGroup;
import org.apache.xerces.xs.XSObjectList;
import org.apache.xerces.xs.XSParticle;
import org.apache.xerces.xs.XSTerm;
import org.apache.xerces.xs.XSTypeDefinition;

public class ComplexTypeExtractor {
    private int baseTypeSize;
    private boolean splitRequested;

    ComplexTypeExtractor(boolean bl) {
        this.splitRequested = bl;
    }

    public int getBaseTypeSize() {
        return this.baseTypeSize;
    }

    private static List<XSParticle> removeSeqOfExt(XSComplexTypeDecl xSComplexTypeDecl) {
        XSParticle xSParticle = xSComplexTypeDecl.getParticle();
        LinkedList<XSParticle> linkedList = new LinkedList<XSParticle>();
        linkedList.add(xSParticle);
        while (!SchemaGrammar.isAnyType((XSTypeDefinition)xSComplexTypeDecl) && xSComplexTypeDecl.getDerivationMethod() == 1) {
            XSComplexTypeDecl xSComplexTypeDecl2 = (XSComplexTypeDecl)xSComplexTypeDecl.getBaseType();
            XSParticle xSParticle2 = xSComplexTypeDecl2.getParticle();
            if (xSParticle2 == null) {
                return linkedList;
            }
            if (xSParticle == xSParticle2) {
                xSComplexTypeDecl = xSComplexTypeDecl2;
                continue;
            }
            List<XSParticle> list = ComplexTypeExtractor.groupParticles(xSParticle.getTerm());
            Preconditions.checkState((list.size() == 2 && list.get(0) == xSParticle2 ? 1 : 0) != 0, (Object)"removeSeqOfExt: unexpected condition in type processing");
            linkedList.remove(0);
            linkedList.addAll(0, list);
            xSComplexTypeDecl = xSComplexTypeDecl2;
            xSParticle = list.get(0);
        }
        return linkedList;
    }

    Pair<List<XSAttributeUse>, List<XSAttributeUse>> getAttributesSplitByExtension(XSComplexTypeDecl xSComplexTypeDecl, XsdTreeView.Options options) {
        List list;
        List list2;
        List list3 = list2 = options.showAttributes.get() ? ComplexTypeExtractor.castObjectList(xSComplexTypeDecl.getAttributeUses()) : Collections.emptyList();
        if (!options.showTypes.get() || !this.splitRequested || list2.isEmpty() || !(xSComplexTypeDecl.getBaseType() instanceof XSComplexTypeDecl)) {
            return Pair.of(Collections.emptyList(), list2);
        }
        if (xSComplexTypeDecl.getDerivationMethod() == 1 && !(list = ComplexTypeExtractor.castObjectList(((XSComplexTypeDecl)xSComplexTypeDecl.getBaseType()).getAttributeUses())).isEmpty()) {
            ArrayList arrayList = new ArrayList(list2);
            arrayList.removeAll(list);
            return Pair.of(list, arrayList);
        }
        return Pair.of(Collections.emptyList(), list2);
    }

    Pair<List<XSParticle>, List<XSParticle>> getParticlesSplitByExtension(XSComplexTypeDecl xSComplexTypeDecl, XsdTreeView.Options options) {
        XSParticle xSParticle = xSComplexTypeDecl.getParticle();
        if (!options.showTypes.get() || !this.splitRequested || xSParticle == null) {
            return Pair.of(Collections.emptyList(), xSParticle == null ? Collections.emptyList() : ComplexTypeExtractor.removeSeqOfExt(xSComplexTypeDecl));
        }
        if (xSComplexTypeDecl.getDerivationMethod() == 1) {
            XSComplexTypeDecl xSComplexTypeDecl2 = (XSComplexTypeDecl)xSComplexTypeDecl.getBaseType();
            XSParticle xSParticle2 = xSComplexTypeDecl2.getParticle();
            if (xSParticle2 == null) {
                return Pair.of(Collections.emptyList(), List.of(xSParticle));
            }
            if (xSParticle == xSParticle2) {
                return Pair.of(ComplexTypeExtractor.removeSeqOfExt(xSComplexTypeDecl2), Collections.emptyList());
            }
            List<XSParticle> list = ComplexTypeExtractor.groupParticles(xSParticle.getTerm());
            Preconditions.checkState((list.size() == 2 && list.get(0) == xSParticle2 ? 1 : 0) != 0, (Object)"getParticlesSplitByExtension: unexpected condition in type processing");
            return Pair.of(ComplexTypeExtractor.removeSeqOfExt(xSComplexTypeDecl2), Arrays.asList(list.get(1)));
        }
        return Pair.of(Collections.emptyList(), List.of(xSParticle));
    }

    public List<TreeNodeControl> extractComplexTypeChildren(XSComplexTypeDecl xSComplexTypeDecl, XsdTreeNode xsdTreeNode, XsdTreeView.Options options) {
        Pair<List<XSAttributeUse>, List<XSAttributeUse>> pair = this.getAttributesSplitByExtension(xSComplexTypeDecl, options);
        Pair<List<XSParticle>, List<XSParticle>> pair2 = this.getParticlesSplitByExtension(xSComplexTypeDecl, options);
        this.baseTypeSize = (((List)pair.getLeft()).isEmpty() ? 0 : 1) + ((List)pair2.getLeft()).size();
        int n = this.baseTypeSize + (((List)pair.getRight()).isEmpty() ? 0 : 1) + ((List)pair2.getRight()).size();
        if (n == 0) {
            return Collections.emptyList();
        }
        ArrayList<TreeNodeControl> arrayList = new ArrayList<TreeNodeControl>(n);
        if (!((List)pair.getLeft()).isEmpty()) {
            arrayList.add(new AttributeNode((List)pair.getLeft(), xsdTreeNode.getParentLayout()));
        }
        for (XSParticle xSParticle : (List)pair2.getLeft()) {
            arrayList.add(new XsdTreeNode(xSParticle, xsdTreeNode));
        }
        if (!((List)pair.getRight()).isEmpty()) {
            arrayList.add(new AttributeNode((List)pair.getRight(), xsdTreeNode.getParentLayout()));
        }
        for (XSParticle xSParticle : (List)pair2.getRight()) {
            arrayList.add(new XsdTreeNode(xSParticle, xsdTreeNode));
        }
        return arrayList;
    }

    public static <T> List<T> castObjectList(XSObjectList xSObjectList) {
        return xSObjectList;
    }

    private static List<XSParticle> groupParticles(XSTerm xSTerm) {
        return ((XSModelGroup)xSTerm).getParticles();
    }
}

