/*
 * Decompiled with CFR 0.152.
 */
package com.xsdexplorer;

import com.xsdexplorer.AnnotationExtractor;
import com.xsdexplorer.TreeNodeControl;
import com.xsdexplorer.XsdTreeView;
import java.util.ArrayList;
import java.util.List;
import java.util.TimerTask;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.TitledPane;
import javafx.scene.input.MouseButton;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import javafx.scene.text.Text;
import org.apache.xerces.xs.XSAnnotation;
import org.apache.xerces.xs.XSAttributeUse;
import org.apache.xerces.xs.XSObjectList;

public class AttributeNode
extends TreeNodeControl {
    private TitledPane attPane = new TitledPane();
    private MyVBox content = new MyVBox();

    public AttributeNode(List<XSAttributeUse> list, XsdTreeView xsdTreeView) {
        this.attPane.setText("attributes");
        this.attPane.setExpanded(false);
        for (XSAttributeUse xSAttributeUse : list) {
            XSAnnotation xSAnnotation;
            String string;
            Label label = new Label(xSAttributeUse.getAttrDeclaration().getName());
            label.getStyleClass().addAll((Object[])new String[]{"attrNodeLabel", xSAttributeUse.getRequired() ? "requiredShape" : "optionalShape"});
            this.content.addAttr(label);
            label.setFocusTraversable(true);
            label.setOnMouseClicked(mouseEvent -> {
                if (mouseEvent.getButton() == MouseButton.PRIMARY) {
                    label.requestFocus();
                    mouseEvent.consume();
                }
            });
            label.focusedProperty().addListener((observableValue, bl, bl2) -> {
                if (bl2.booleanValue()) {
                    xsdTreeView.onNodeFocused(xSAttributeUse);
                }
            });
            XSObjectList xSObjectList = xSAttributeUse.getAnnotations();
            if (xSObjectList.isEmpty() || (string = AnnotationExtractor.extract((xSAnnotation = (XSAnnotation)xSObjectList.get(0)).getAnnotationString())) == null) continue;
            Text text = new Text(string);
            text.getStyleClass().add((Object)"annotation");
            this.content.addAnnotation(text);
        }
        this.attPane.setContent((Node)this.content);
        this.attPane.setAnimated(false);
        this.content.setManaged(false);
        this.content.managedProperty().bind((ObservableValue)this.attPane.expandedProperty());
        xsdTreeView.addNode(this);
    }

    @Override
    Region control() {
        return this.attPane;
    }

    @Override
    boolean isOpen() {
        return false;
    }

    @Override
    boolean isOptional() {
        return false;
    }

    @Override
    void expand(boolean bl) {
    }

    private static class MyVBox
    extends VBox {
        List<Node> attributes = new ArrayList<Node>();
        List<Text> annotations = new ArrayList<Text>();

        MyVBox() {
            super(8.0);
            this.setPadding(new Insets(8.0, 8.0, 8.0, 8.0));
        }

        void addAttr(Label label) {
            this.getChildren().add((Object)label);
            this.attributes.add((Node)label);
        }

        void addAnnotation(Text text) {
            this.getChildren().add((Object)text);
            this.annotations.add(text);
        }

        protected double computeMinWidth(double d) {
            this.fixAnnotationWrap();
            return super.computeMinWidth(d);
        }

        protected double computePrefWidth(double d) {
            this.fixAnnotationWrap();
            return super.computePrefWidth(d);
        }

        private void fixAnnotationWrap() {
            if (!this.annotations.isEmpty()) {
                double d = this.attributes.stream().mapToDouble(node -> node.prefWidth(-1.0)).max().getAsDouble();
                double d2 = Double.max(140.0, d);
                for (Text text : this.annotations) {
                    text.setWrappingWidth(d2);
                }
            }
        }
    }

    private class MyTimerTask
    extends TimerTask {
        private MyTimerTask() {
        }

        @Override
        public void run() {
            AttributeNode.this.content.setManaged(false);
        }
    }
}

