/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.xs.alternative;

import java.util.Enumeration;
import java.util.HashMap;
import org.apache.xerces.dom.PSVIAttrNSImpl;
import org.apache.xerces.dom.PSVIDocumentImpl;
import org.apache.xerces.dom.PSVIElementNSImpl;
import org.apache.xerces.impl.xpath.XPath20;
import org.apache.xerces.impl.xs.AbstractXPath2EngineImpl;
import org.apache.xerces.impl.xs.SchemaSymbols;
import org.apache.xerces.impl.xs.alternative.XSTypeAlternativeImpl;
import org.apache.xerces.util.NamespaceSupport;
import org.apache.xerces.xni.NamespaceContext;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.XMLAttributes;
import org.eclipse.wst.xml.xpath2.processor.DynamicContext;
import org.eclipse.wst.xml.xpath2.processor.ast.XPath;

public class Test
extends AbstractXPath2EngineImpl {
    protected final XSTypeAlternativeImpl fTypeAlternative;
    protected final String fExpression;
    protected final XPath20 fXPath;
    protected final XPath fEclipseXPathImpl;
    protected final NamespaceSupport fXPath2NamespaceContext;

    public Test(XPath20 xpath, XSTypeAlternativeImpl typeAlternative, NamespaceSupport namespaceContext) {
        this.fXPath = xpath;
        this.fExpression = xpath == null ? "" : xpath.getXPathStrValue();
        this.fEclipseXPathImpl = null;
        this.fTypeAlternative = typeAlternative;
        this.fXPath2NamespaceContext = namespaceContext;
    }

    public Test(XPath xpath, String expression, XSTypeAlternativeImpl typeAlternative, NamespaceSupport namespaceContext) {
        this.fXPath = null;
        this.fExpression = expression == null ? "" : expression;
        this.fEclipseXPathImpl = xpath;
        this.fTypeAlternative = typeAlternative;
        this.fXPath2NamespaceContext = namespaceContext;
    }

    public NamespaceSupport getNamespaceContext() {
        return this.fXPath2NamespaceContext;
    }

    public XSTypeAlternativeImpl getTypeAlternative() {
        return this.fTypeAlternative;
    }

    public Object getXPath() {
        XPath20 xpath = null;
        if (this.fXPath != null) {
            xpath = this.fXPath;
        } else if (this.fEclipseXPathImpl != null) {
            xpath = this.fEclipseXPathImpl;
        }
        return xpath;
    }

    public boolean evaluateTest(QName element, XMLAttributes attributes, NamespaceContext instanceNamespaceContext, String expandedSystemId) {
        if (this.fXPath != null) {
            return this.fXPath.evaluateTest(element, attributes);
        }
        if (this.fEclipseXPathImpl != null) {
            return this.evaluateTestWithEclipseXPathEngine(element, attributes, instanceNamespaceContext, expandedSystemId);
        }
        return false;
    }

    public String toString() {
        return this.fExpression;
    }

    private boolean evaluateTestWithEclipseXPathEngine(QName element, XMLAttributes attributes, NamespaceContext instanceNamespaceContext, String expandedSystemId) {
        boolean evaluationResult = false;
        try {
            PSVIDocumentImpl document = new PSVIDocumentImpl();
            document.setDocumentURI(expandedSystemId);
            PSVIElementNSImpl elem = new PSVIElementNSImpl(document, element.uri, element.rawname);
            for (int attrIndx = 0; attrIndx < attributes.getLength(); ++attrIndx) {
                PSVIAttrNSImpl attrNode = new PSVIAttrNSImpl(document, attributes.getURI(attrIndx), attributes.getQName(attrIndx));
                attrNode.setNodeValue(attributes.getValue(attrIndx));
                elem.setAttributeNode(attrNode);
            }
            Enumeration currPrefixes = instanceNamespaceContext.getAllPrefixes();
            while (currPrefixes.hasMoreElements()) {
                String prefix = (String)currPrefixes.nextElement();
                String nsUri = instanceNamespaceContext.getURI(prefix);
                if ("xml".equals(prefix) || "xmlns".equals(prefix)) continue;
                String attrName = prefix != null && !SchemaSymbols.EMPTY_STRING.equals(prefix) ? "xmlns:" + prefix : "xmlns";
                elem.setAttribute(attrName, nsUri);
            }
            document.appendChild(elem);
            HashMap<String, Object> eclipseXpathParams = new HashMap<String, Object>();
            eclipseXpathParams.put("XPATH2_NS_CONTEXT", this.fXPath2NamespaceContext);
            eclipseXpathParams.put("CTA-EVALUATOR", Boolean.TRUE);
            DynamicContext xpath2DynamicContext = this.initXPath2DynamicContext(null, document, eclipseXpathParams);
            xpath2DynamicContext.set_base_uri(this.fTypeAlternative.getBaseURI());
            if (this.fTypeAlternative.fXPathDefaultNamespace != null) {
                this.addNamespaceBindingToXPath2DynamicContext(null, this.fTypeAlternative.fXPathDefaultNamespace);
            }
            evaluationResult = this.evaluateXPathExpr(this.fEclipseXPathImpl, elem);
        }
        catch (Exception ex) {
            evaluationResult = false;
        }
        return evaluationResult;
    }
}

