/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.xpath.regex;

import java.util.HashMap;
import org.apache.xerces.impl.xpath.regex.REConstants;
import org.apache.xerces.impl.xpath.regex.REUtil;
import org.apache.xerces.impl.xpath.regex.RangeToken;
import org.apache.xerces.impl.xpath.regex.RangeTokenMap;
import org.apache.xerces.impl.xpath.regex.Token;

final class XML11TokenMap
implements RangeTokenMap {
    private HashMap ranges;
    private HashMap ranges2;

    private XML11TokenMap() {
        this.createRanges();
    }

    static RangeTokenMap instance() {
        return new XML11TokenMap();
    }

    private void createRanges() {
        this.ranges = new HashMap();
        this.ranges2 = new HashMap();
        RangeToken tok = Token.createRange();
        REUtil.setupRange((Token)tok, "\t\n\r\r  ");
        this.ranges.put("xml:isSpace", tok);
        this.ranges2.put("xml:isSpace", Token.complementRanges(tok));
        tok = Token.createRange();
        REUtil.setupRange((Token)tok, REConstants.DIGITS_INTS);
        this.ranges.put("xml:isDigit", tok);
        this.ranges2.put("xml:isDigit", Token.complementRanges(tok));
        tok = Token.createRange();
        ((Token)tok).mergeRanges(Token.getRange("P", true));
        ((Token)tok).mergeRanges(Token.getRange("Z", true));
        ((Token)tok).mergeRanges(Token.getRange("C", true));
        this.ranges2.put("xml:isWord", tok);
        this.ranges.put("xml:isWord", Token.complementRanges(tok));
        tok = Token.createRange();
        REUtil.setupRange((Token)tok, REConstants.NAMECHARS11_INTS);
        this.ranges.put("xml:isNameChar", tok);
        this.ranges2.put("xml:isNameChar", Token.complementRanges(tok));
        tok = Token.createRange();
        REUtil.setupRange((Token)tok, REConstants.NAMESTARTCHARS11_INTS);
        this.ranges.put("xml:isInitialNameChar", tok);
        this.ranges2.put("xml:isInitialNameChar", Token.complementRanges(tok));
    }

    @Override
    public RangeToken get(String name, boolean positive) {
        return positive ? (RangeToken)this.ranges.get(name) : (RangeToken)this.ranges2.get(name);
    }
}

